/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ResourceType;
import java.io.IOException;

public final class CheckNameAvailabilityInput
implements JsonSerializable<CheckNameAvailabilityInput> {
    private String name;
    private ResourceType type;
    private static final ClientLogger LOGGER = new ClientLogger(CheckNameAvailabilityInput.class);

    public String name() {
        return this.name;
    }

    public CheckNameAvailabilityInput withName(String name) {
        this.name = name;
        return this;
    }

    public ResourceType type() {
        return this.type;
    }

    public CheckNameAvailabilityInput withType(ResourceType type) {
        this.type = type;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model CheckNameAvailabilityInput"));
        }
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model CheckNameAvailabilityInput"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static CheckNameAvailabilityInput fromJson(JsonReader jsonReader) throws IOException {
        return (CheckNameAvailabilityInput)jsonReader.readObject(reader -> {
            CheckNameAvailabilityInput deserializedCheckNameAvailabilityInput = new CheckNameAvailabilityInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCheckNameAvailabilityInput.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCheckNameAvailabilityInput.type = ResourceType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCheckNameAvailabilityInput;
        });
    }
}

