/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.DeliveryRuleAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleCondition;
import java.io.IOException;
import java.util.List;

public final class DeliveryRule
implements JsonSerializable<DeliveryRule> {
    private String name;
    private int order;
    private List<DeliveryRuleCondition> conditions;
    private List<DeliveryRuleAction> actions;
    private static final ClientLogger LOGGER = new ClientLogger(DeliveryRule.class);

    public String name() {
        return this.name;
    }

    public DeliveryRule withName(String name) {
        this.name = name;
        return this;
    }

    public int order() {
        return this.order;
    }

    public DeliveryRule withOrder(int order) {
        this.order = order;
        return this;
    }

    public List<DeliveryRuleCondition> conditions() {
        return this.conditions;
    }

    public DeliveryRule withConditions(List<DeliveryRuleCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public List<DeliveryRuleAction> actions() {
        return this.actions;
    }

    public DeliveryRule withActions(List<DeliveryRuleAction> actions) {
        this.actions = actions;
        return this;
    }

    public void validate() {
        if (this.conditions() != null) {
            this.conditions().forEach(e -> e.validate());
        }
        if (this.actions() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property actions in model DeliveryRule"));
        }
        this.actions().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("order", this.order);
        jsonWriter.writeArrayField("actions", this.actions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("conditions", this.conditions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DeliveryRule fromJson(JsonReader jsonReader) throws IOException {
        return (DeliveryRule)jsonReader.readObject(reader -> {
            DeliveryRule deserializedDeliveryRule = new DeliveryRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("order".equals(fieldName)) {
                    deserializedDeliveryRule.order = reader.getInt();
                    continue;
                }
                if ("actions".equals(fieldName)) {
                    List actions;
                    deserializedDeliveryRule.actions = actions = reader.readArray(reader1 -> DeliveryRuleAction.fromJson(reader1));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeliveryRule.name = reader.getString();
                    continue;
                }
                if ("conditions".equals(fieldName)) {
                    List conditions;
                    deserializedDeliveryRule.conditions = conditions = reader.readArray(reader1 -> DeliveryRuleCondition.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryRule;
        });
    }
}

