/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.CacheExpirationActionParameters;
import com.azure.resourcemanager.cdn.models.DeliveryRuleAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleActionValue;
import java.io.IOException;

public final class DeliveryRuleCacheExpirationAction
extends DeliveryRuleAction {
    private DeliveryRuleActionValue name = DeliveryRuleActionValue.CACHE_EXPIRATION;
    private CacheExpirationActionParameters parameters;
    private static final ClientLogger LOGGER = new ClientLogger(DeliveryRuleCacheExpirationAction.class);

    @Override
    public DeliveryRuleActionValue name() {
        return this.name;
    }

    public CacheExpirationActionParameters parameters() {
        return this.parameters;
    }

    public DeliveryRuleCacheExpirationAction withParameters(CacheExpirationActionParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parameters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parameters in model DeliveryRuleCacheExpirationAction"));
        }
        this.parameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static DeliveryRuleCacheExpirationAction fromJson(JsonReader jsonReader) throws IOException {
        return (DeliveryRuleCacheExpirationAction)jsonReader.readObject(reader -> {
            DeliveryRuleCacheExpirationAction deserializedDeliveryRuleCacheExpirationAction = new DeliveryRuleCacheExpirationAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    deserializedDeliveryRuleCacheExpirationAction.parameters = CacheExpirationActionParameters.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDeliveryRuleCacheExpirationAction.name = DeliveryRuleActionValue.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDeliveryRuleCacheExpirationAction;
        });
    }
}

