// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The JSON object that contains the properties to validate a domain.
 */
@Immutable
public final class DomainValidationProperties implements JsonSerializable<DomainValidationProperties> {
    /*
     * Challenge used for DNS TXT record or file based validation
     */
    private String validationToken;

    /*
     * The date time that the token expires
     */
    private String expirationDate;

    /**
     * Creates an instance of DomainValidationProperties class.
     */
    public DomainValidationProperties() {
    }

    /**
     * Get the validationToken property: Challenge used for DNS TXT record or file based validation.
     * 
     * @return the validationToken value.
     */
    public String validationToken() {
        return this.validationToken;
    }

    /**
     * Get the expirationDate property: The date time that the token expires.
     * 
     * @return the expirationDate value.
     */
    public String expirationDate() {
        return this.expirationDate;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DomainValidationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DomainValidationProperties if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DomainValidationProperties.
     */
    public static DomainValidationProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DomainValidationProperties deserializedDomainValidationProperties = new DomainValidationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("validationToken".equals(fieldName)) {
                    deserializedDomainValidationProperties.validationToken = reader.getString();
                } else if ("expirationDate".equals(fieldName)) {
                    deserializedDomainValidationProperties.expirationDate = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDomainValidationProperties;
        });
    }
}
