/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.SecurityPolicyProperties;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.SecurityPolicyPropertiesParameters;
import java.io.IOException;

public final class SecurityPolicyInner
extends ProxyResource {
    private SecurityPolicyProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private SecurityPolicyProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String profileName() {
        return this.innerProperties() == null ? null : this.innerProperties().profileName();
    }

    public SecurityPolicyPropertiesParameters parameters() {
        return this.innerProperties() == null ? null : this.innerProperties().parameters();
    }

    public SecurityPolicyInner withParameters(SecurityPolicyPropertiesParameters parameters) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityPolicyProperties();
        }
        this.innerProperties().withParameters(parameters);
        return this;
    }

    public AfdProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public DeploymentStatus deploymentStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentStatus();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static SecurityPolicyInner fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityPolicyInner)((Object)jsonReader.readObject(reader -> {
            SecurityPolicyInner deserializedSecurityPolicyInner = new SecurityPolicyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSecurityPolicyInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSecurityPolicyInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSecurityPolicyInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSecurityPolicyInner.innerProperties = SecurityPolicyProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSecurityPolicyInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityPolicyInner;
        }));
    }
}

