/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.OperationInner;
import java.io.IOException;
import java.util.List;

public final class OperationsListResult
implements JsonSerializable<OperationsListResult> {
    private List<OperationInner> value;
    private String nextLink;

    public List<OperationInner> value() {
        return this.value;
    }

    public OperationsListResult withValue(List<OperationInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public OperationsListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() != null) {
            this.value().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static OperationsListResult fromJson(JsonReader jsonReader) throws IOException {
        return (OperationsListResult)jsonReader.readObject(reader -> {
            OperationsListResult deserializedOperationsListResult = new OperationsListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedOperationsListResult.value = value = reader.readArray(reader1 -> OperationInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedOperationsListResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationsListResult;
        });
    }
}

