/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.SocketAddrOperator;
import com.azure.resourcemanager.cdn.models.Transform;
import java.io.IOException;
import java.util.List;

public final class SocketAddrMatchConditionParameters
implements JsonSerializable<SocketAddrMatchConditionParameters> {
    private String typeName = "DeliveryRuleSocketAddrConditionParameters";
    private SocketAddrOperator operator;
    private Boolean negateCondition;
    private List<String> matchValues;
    private List<Transform> transforms;
    private static final ClientLogger LOGGER = new ClientLogger(SocketAddrMatchConditionParameters.class);

    public String typeName() {
        return this.typeName;
    }

    public SocketAddrMatchConditionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public SocketAddrOperator operator() {
        return this.operator;
    }

    public SocketAddrMatchConditionParameters withOperator(SocketAddrOperator operator) {
        this.operator = operator;
        return this;
    }

    public Boolean negateCondition() {
        return this.negateCondition;
    }

    public SocketAddrMatchConditionParameters withNegateCondition(Boolean negateCondition) {
        this.negateCondition = negateCondition;
        return this;
    }

    public List<String> matchValues() {
        return this.matchValues;
    }

    public SocketAddrMatchConditionParameters withMatchValues(List<String> matchValues) {
        this.matchValues = matchValues;
        return this;
    }

    public List<Transform> transforms() {
        return this.transforms;
    }

    public SocketAddrMatchConditionParameters withTransforms(List<Transform> transforms) {
        this.transforms = transforms;
        return this;
    }

    public void validate() {
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model SocketAddrMatchConditionParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeBooleanField("negateCondition", this.negateCondition);
        jsonWriter.writeArrayField("matchValues", this.matchValues, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("transforms", this.transforms, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        return jsonWriter.writeEndObject();
    }

    public static SocketAddrMatchConditionParameters fromJson(JsonReader jsonReader) throws IOException {
        return (SocketAddrMatchConditionParameters)jsonReader.readObject(reader -> {
            SocketAddrMatchConditionParameters deserializedSocketAddrMatchConditionParameters = new SocketAddrMatchConditionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operator".equals(fieldName)) {
                    deserializedSocketAddrMatchConditionParameters.operator = SocketAddrOperator.fromString(reader.getString());
                    continue;
                }
                if ("negateCondition".equals(fieldName)) {
                    deserializedSocketAddrMatchConditionParameters.negateCondition = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("matchValues".equals(fieldName)) {
                    List matchValues;
                    deserializedSocketAddrMatchConditionParameters.matchValues = matchValues = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("transforms".equals(fieldName)) {
                    List transforms;
                    deserializedSocketAddrMatchConditionParameters.transforms = transforms = reader.readArray(reader1 -> Transform.fromString(reader1.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSocketAddrMatchConditionParameters;
        });
    }
}

