// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ProfileLogScrubbing;
import com.azure.resourcemanager.cdn.models.ProfileProvisioningState;
import com.azure.resourcemanager.cdn.models.ProfileResourceState;
import java.io.IOException;
import java.util.Map;

/**
 * The JSON object that contains the properties required to create a profile.
 */
@Fluent
public final class ProfileProperties implements JsonSerializable<ProfileProperties> {
    /*
     * Resource status of the profile.
     */
    private ProfileResourceState resourceState;

    /*
     * Provisioning status of the profile.
     */
    private ProfileProvisioningState provisioningState;

    /*
     * Key-Value pair representing additional properties for profiles.
     */
    private Map<String, String> extendedProperties;

    /*
     * The Id of the frontdoor.
     */
    private String frontDoorId;

    /*
     * Send and receive timeout on forwarding request to the origin. When timeout is reached, the request fails and
     * returns.
     */
    private Integer originResponseTimeoutSeconds;

    /*
     * Defines rules that scrub sensitive fields in the Azure Front Door profile logs.
     */
    private ProfileLogScrubbing logScrubbing;

    /**
     * Creates an instance of ProfileProperties class.
     */
    public ProfileProperties() {
    }

    /**
     * Get the resourceState property: Resource status of the profile.
     * 
     * @return the resourceState value.
     */
    public ProfileResourceState resourceState() {
        return this.resourceState;
    }

    /**
     * Get the provisioningState property: Provisioning status of the profile.
     * 
     * @return the provisioningState value.
     */
    public ProfileProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the extendedProperties property: Key-Value pair representing additional properties for profiles.
     * 
     * @return the extendedProperties value.
     */
    public Map<String, String> extendedProperties() {
        return this.extendedProperties;
    }

    /**
     * Get the frontDoorId property: The Id of the frontdoor.
     * 
     * @return the frontDoorId value.
     */
    public String frontDoorId() {
        return this.frontDoorId;
    }

    /**
     * Get the originResponseTimeoutSeconds property: Send and receive timeout on forwarding request to the origin. When
     * timeout is reached, the request fails and returns.
     * 
     * @return the originResponseTimeoutSeconds value.
     */
    public Integer originResponseTimeoutSeconds() {
        return this.originResponseTimeoutSeconds;
    }

    /**
     * Set the originResponseTimeoutSeconds property: Send and receive timeout on forwarding request to the origin. When
     * timeout is reached, the request fails and returns.
     * 
     * @param originResponseTimeoutSeconds the originResponseTimeoutSeconds value to set.
     * @return the ProfileProperties object itself.
     */
    public ProfileProperties withOriginResponseTimeoutSeconds(Integer originResponseTimeoutSeconds) {
        this.originResponseTimeoutSeconds = originResponseTimeoutSeconds;
        return this;
    }

    /**
     * Get the logScrubbing property: Defines rules that scrub sensitive fields in the Azure Front Door profile logs.
     * 
     * @return the logScrubbing value.
     */
    public ProfileLogScrubbing logScrubbing() {
        return this.logScrubbing;
    }

    /**
     * Set the logScrubbing property: Defines rules that scrub sensitive fields in the Azure Front Door profile logs.
     * 
     * @param logScrubbing the logScrubbing value to set.
     * @return the ProfileProperties object itself.
     */
    public ProfileProperties withLogScrubbing(ProfileLogScrubbing logScrubbing) {
        this.logScrubbing = logScrubbing;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (logScrubbing() != null) {
            logScrubbing().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("originResponseTimeoutSeconds", this.originResponseTimeoutSeconds);
        jsonWriter.writeJsonField("logScrubbing", this.logScrubbing);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProfileProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProfileProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProfileProperties.
     */
    public static ProfileProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProfileProperties deserializedProfileProperties = new ProfileProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("resourceState".equals(fieldName)) {
                    deserializedProfileProperties.resourceState = ProfileResourceState.fromString(reader.getString());
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedProfileProperties.provisioningState
                        = ProfileProvisioningState.fromString(reader.getString());
                } else if ("extendedProperties".equals(fieldName)) {
                    Map<String, String> extendedProperties = reader.readMap(reader1 -> reader1.getString());
                    deserializedProfileProperties.extendedProperties = extendedProperties;
                } else if ("frontDoorId".equals(fieldName)) {
                    deserializedProfileProperties.frontDoorId = reader.getString();
                } else if ("originResponseTimeoutSeconds".equals(fieldName)) {
                    deserializedProfileProperties.originResponseTimeoutSeconds = reader.getNullable(JsonReader::getInt);
                } else if ("logScrubbing".equals(fieldName)) {
                    deserializedProfileProperties.logScrubbing = ProfileLogScrubbing.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProfileProperties;
        });
    }
}
