// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Output of the validate probe API.
 */
@Immutable
public final class ValidateProbeOutputInner implements JsonSerializable<ValidateProbeOutputInner> {
    /*
     * Indicates whether the probe URL is accepted or not.
     */
    private Boolean isValid;

    /*
     * Specifies the error code when the probe url is not accepted.
     */
    private String errorCode;

    /*
     * The detailed error message describing why the probe URL is not accepted.
     */
    private String message;

    /**
     * Creates an instance of ValidateProbeOutputInner class.
     */
    public ValidateProbeOutputInner() {
    }

    /**
     * Get the isValid property: Indicates whether the probe URL is accepted or not.
     * 
     * @return the isValid value.
     */
    public Boolean isValid() {
        return this.isValid;
    }

    /**
     * Get the errorCode property: Specifies the error code when the probe url is not accepted.
     * 
     * @return the errorCode value.
     */
    public String errorCode() {
        return this.errorCode;
    }

    /**
     * Get the message property: The detailed error message describing why the probe URL is not accepted.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ValidateProbeOutputInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ValidateProbeOutputInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ValidateProbeOutputInner.
     */
    public static ValidateProbeOutputInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ValidateProbeOutputInner deserializedValidateProbeOutputInner = new ValidateProbeOutputInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isValid".equals(fieldName)) {
                    deserializedValidateProbeOutputInner.isValid = reader.getNullable(JsonReader::getBoolean);
                } else if ("errorCode".equals(fieldName)) {
                    deserializedValidateProbeOutputInner.errorCode = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedValidateProbeOutputInner.message = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedValidateProbeOutputInner;
        });
    }
}
