// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Log specification of operation.
 */
@Fluent
public final class LogSpecification implements JsonSerializable<LogSpecification> {
    /*
     * Name of log specification.
     */
    private String name;

    /*
     * Display name of log specification.
     */
    private String displayName;

    /*
     * Blob duration of specification.
     */
    private String blobDuration;

    /*
     * Pattern to filter based on name
     */
    private String logFilterPattern;

    /**
     * Creates an instance of LogSpecification class.
     */
    public LogSpecification() {
    }

    /**
     * Get the name property: Name of log specification.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of log specification.
     * 
     * @param name the name value to set.
     * @return the LogSpecification object itself.
     */
    public LogSpecification withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the displayName property: Display name of log specification.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Display name of log specification.
     * 
     * @param displayName the displayName value to set.
     * @return the LogSpecification object itself.
     */
    public LogSpecification withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the blobDuration property: Blob duration of specification.
     * 
     * @return the blobDuration value.
     */
    public String blobDuration() {
        return this.blobDuration;
    }

    /**
     * Set the blobDuration property: Blob duration of specification.
     * 
     * @param blobDuration the blobDuration value to set.
     * @return the LogSpecification object itself.
     */
    public LogSpecification withBlobDuration(String blobDuration) {
        this.blobDuration = blobDuration;
        return this;
    }

    /**
     * Get the logFilterPattern property: Pattern to filter based on name.
     * 
     * @return the logFilterPattern value.
     */
    public String logFilterPattern() {
        return this.logFilterPattern;
    }

    /**
     * Set the logFilterPattern property: Pattern to filter based on name.
     * 
     * @param logFilterPattern the logFilterPattern value to set.
     * @return the LogSpecification object itself.
     */
    public LogSpecification withLogFilterPattern(String logFilterPattern) {
        this.logFilterPattern = logFilterPattern;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("blobDuration", this.blobDuration);
        jsonWriter.writeStringField("logFilterPattern", this.logFilterPattern);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogSpecification from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogSpecification if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the LogSpecification.
     */
    public static LogSpecification fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogSpecification deserializedLogSpecification = new LogSpecification();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedLogSpecification.name = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedLogSpecification.displayName = reader.getString();
                } else if ("blobDuration".equals(fieldName)) {
                    deserializedLogSpecification.blobDuration = reader.getString();
                } else if ("logFilterPattern".equals(fieldName)) {
                    deserializedLogSpecification.logFilterPattern = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogSpecification;
        });
    }
}
