// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Managed Certificate used for https.
 */
@Immutable
public final class ManagedCertificateParameters extends SecretParameters {
    /*
     * The type of the secret resource.
     */
    private SecretType type = SecretType.MANAGED_CERTIFICATE;

    /*
     * Subject name in the certificate.
     */
    private String subject;

    /*
     * Certificate expiration date.
     */
    private String expirationDate;

    /**
     * Creates an instance of ManagedCertificateParameters class.
     */
    public ManagedCertificateParameters() {
    }

    /**
     * Get the type property: The type of the secret resource.
     * 
     * @return the type value.
     */
    @Override
    public SecretType type() {
        return this.type;
    }

    /**
     * Get the subject property: Subject name in the certificate.
     * 
     * @return the subject value.
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Get the expirationDate property: Certificate expiration date.
     * 
     * @return the expirationDate value.
     */
    public String expirationDate() {
        return this.expirationDate;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedCertificateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedCertificateParameters if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ManagedCertificateParameters.
     */
    public static ManagedCertificateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedCertificateParameters deserializedManagedCertificateParameters = new ManagedCertificateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedManagedCertificateParameters.type = SecretType.fromString(reader.getString());
                } else if ("subject".equals(fieldName)) {
                    deserializedManagedCertificateParameters.subject = reader.getString();
                } else if ("expirationDate".equals(fieldName)) {
                    deserializedManagedCertificateParameters.expirationDate = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedCertificateParameters;
        });
    }
}
