// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Provisioning status of the origin group.
 */
public final class OriginGroupProvisioningState extends ExpandableStringEnum<OriginGroupProvisioningState> {
    /**
     * Static value Succeeded for OriginGroupProvisioningState.
     */
    public static final OriginGroupProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Failed for OriginGroupProvisioningState.
     */
    public static final OriginGroupProvisioningState FAILED = fromString("Failed");

    /**
     * Static value Updating for OriginGroupProvisioningState.
     */
    public static final OriginGroupProvisioningState UPDATING = fromString("Updating");

    /**
     * Static value Deleting for OriginGroupProvisioningState.
     */
    public static final OriginGroupProvisioningState DELETING = fromString("Deleting");

    /**
     * Static value Creating for OriginGroupProvisioningState.
     */
    public static final OriginGroupProvisioningState CREATING = fromString("Creating");

    /**
     * Creates a new instance of OriginGroupProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public OriginGroupProvisioningState() {
    }

    /**
     * Creates or finds a OriginGroupProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding OriginGroupProvisioningState.
     */
    public static OriginGroupProvisioningState fromString(String name) {
        return fromString(name, OriginGroupProvisioningState.class);
    }

    /**
     * Gets known OriginGroupProvisioningState values.
     * 
     * @return known OriginGroupProvisioningState values.
     */
    public static Collection<OriginGroupProvisioningState> values() {
        return values(OriginGroupProvisioningState.class);
    }
}
