// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

/**
 * Defines how CDN caches requests that include query strings. You can ignore any query strings when caching, bypass
 * caching to prevent requests that contain query strings from being cached, or cache every request with a unique URL.
 */
public enum QueryStringCachingBehavior {
    /**
     * Enum value IgnoreQueryString.
     */
    IGNORE_QUERY_STRING("IgnoreQueryString"),

    /**
     * Enum value BypassCaching.
     */
    BYPASS_CACHING("BypassCaching"),

    /**
     * Enum value UseQueryString.
     */
    USE_QUERY_STRING("UseQueryString"),

    /**
     * Enum value NotSet.
     */
    NOT_SET("NotSet");

    /**
     * The actual serialized value for a QueryStringCachingBehavior instance.
     */
    private final String value;

    QueryStringCachingBehavior(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a QueryStringCachingBehavior instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed QueryStringCachingBehavior object, or null if unable to parse.
     */
    public static QueryStringCachingBehavior fromString(String value) {
        if (value == null) {
            return null;
        }
        QueryStringCachingBehavior[] items = QueryStringCachingBehavior.values();
        for (QueryStringCachingBehavior item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
