// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines the parameters for the route configuration override action.
 */
@Fluent
public final class RouteConfigurationOverrideActionParameters
    implements JsonSerializable<RouteConfigurationOverrideActionParameters> {
    /*
     * The typeName property.
     */
    private String typeName = "DeliveryRuleRouteConfigurationOverrideActionParameters";

    /*
     * A reference to the origin group override configuration. Leave empty to use the default origin group on route.
     */
    private OriginGroupOverride originGroupOverride;

    /*
     * The caching configuration associated with this rule. To disable caching, do not provide a cacheConfiguration
     * object.
     */
    private CacheConfiguration cacheConfiguration;

    /**
     * Creates an instance of RouteConfigurationOverrideActionParameters class.
     */
    public RouteConfigurationOverrideActionParameters() {
    }

    /**
     * Get the typeName property: The typeName property.
     * 
     * @return the typeName value.
     */
    public String typeName() {
        return this.typeName;
    }

    /**
     * Set the typeName property: The typeName property.
     * 
     * @param typeName the typeName value to set.
     * @return the RouteConfigurationOverrideActionParameters object itself.
     */
    public RouteConfigurationOverrideActionParameters withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
     * Get the originGroupOverride property: A reference to the origin group override configuration. Leave empty to use
     * the default origin group on route.
     * 
     * @return the originGroupOverride value.
     */
    public OriginGroupOverride originGroupOverride() {
        return this.originGroupOverride;
    }

    /**
     * Set the originGroupOverride property: A reference to the origin group override configuration. Leave empty to use
     * the default origin group on route.
     * 
     * @param originGroupOverride the originGroupOverride value to set.
     * @return the RouteConfigurationOverrideActionParameters object itself.
     */
    public RouteConfigurationOverrideActionParameters withOriginGroupOverride(OriginGroupOverride originGroupOverride) {
        this.originGroupOverride = originGroupOverride;
        return this;
    }

    /**
     * Get the cacheConfiguration property: The caching configuration associated with this rule. To disable caching, do
     * not provide a cacheConfiguration object.
     * 
     * @return the cacheConfiguration value.
     */
    public CacheConfiguration cacheConfiguration() {
        return this.cacheConfiguration;
    }

    /**
     * Set the cacheConfiguration property: The caching configuration associated with this rule. To disable caching, do
     * not provide a cacheConfiguration object.
     * 
     * @param cacheConfiguration the cacheConfiguration value to set.
     * @return the RouteConfigurationOverrideActionParameters object itself.
     */
    public RouteConfigurationOverrideActionParameters withCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (originGroupOverride() != null) {
            originGroupOverride().validate();
        }
        if (cacheConfiguration() != null) {
            cacheConfiguration().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("typeName", this.typeName);
        jsonWriter.writeJsonField("originGroupOverride", this.originGroupOverride);
        jsonWriter.writeJsonField("cacheConfiguration", this.cacheConfiguration);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RouteConfigurationOverrideActionParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RouteConfigurationOverrideActionParameters if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RouteConfigurationOverrideActionParameters.
     */
    public static RouteConfigurationOverrideActionParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RouteConfigurationOverrideActionParameters deserializedRouteConfigurationOverrideActionParameters
                = new RouteConfigurationOverrideActionParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("originGroupOverride".equals(fieldName)) {
                    deserializedRouteConfigurationOverrideActionParameters.originGroupOverride
                        = OriginGroupOverride.fromJson(reader);
                } else if ("cacheConfiguration".equals(fieldName)) {
                    deserializedRouteConfigurationOverrideActionParameters.cacheConfiguration
                        = CacheConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRouteConfigurationOverrideActionParameters;
        });
    }
}
