// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.RuleInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list rules. It contains a list of rule objects and a URL link to get the next set of
 * results.
 */
@Fluent
public final class RuleListResult implements JsonSerializable<RuleListResult> {
    /*
     * List of AzureFrontDoor rules within a rule set.
     */
    private List<RuleInner> value;

    /*
     * URL to get the next set of rule objects if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of RuleListResult class.
     */
    public RuleListResult() {
    }

    /**
     * Get the value property: List of AzureFrontDoor rules within a rule set.
     * 
     * @return the value value.
     */
    public List<RuleInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: URL to get the next set of rule objects if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of rule objects if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the RuleListResult object itself.
     */
    public RuleListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RuleListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RuleListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RuleListResult.
     */
    public static RuleListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RuleListResult deserializedRuleListResult = new RuleListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<RuleInner> value = reader.readArray(reader1 -> RuleInner.fromJson(reader1));
                    deserializedRuleListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedRuleListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRuleListResult;
        });
    }
}
