// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The json object containing security policy parameters.
 */
@Immutable
public class SecurityPolicyPropertiesParameters implements JsonSerializable<SecurityPolicyPropertiesParameters> {
    /*
     * The type of the Security policy to create.
     */
    private SecurityPolicyType type = SecurityPolicyType.fromString("SecurityPolicyPropertiesParameters");

    /**
     * Creates an instance of SecurityPolicyPropertiesParameters class.
     */
    public SecurityPolicyPropertiesParameters() {
    }

    /**
     * Get the type property: The type of the Security policy to create.
     * 
     * @return the type value.
     */
    public SecurityPolicyType type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityPolicyPropertiesParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityPolicyPropertiesParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityPolicyPropertiesParameters.
     */
    public static SecurityPolicyPropertiesParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject()) {
                readerToUse.nextToken(); // Prepare for reading
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    } else {
                        readerToUse.skipChildren();
                    }
                }
                // Use the discriminator value to determine which subtype should be deserialized.
                if ("WebApplicationFirewall".equals(discriminatorValue)) {
                    return SecurityPolicyWebApplicationFirewallParameters.fromJson(readerToUse.reset());
                } else {
                    return fromJsonKnownDiscriminator(readerToUse.reset());
                }
            }
        });
    }

    static SecurityPolicyPropertiesParameters fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityPolicyPropertiesParameters deserializedSecurityPolicyPropertiesParameters
                = new SecurityPolicyPropertiesParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedSecurityPolicyPropertiesParameters.type
                        = SecurityPolicyType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityPolicyPropertiesParameters;
        });
    }
}
