/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.DeliveryRuleAction;
import com.azure.resourcemanager.cdn.models.DeliveryRuleActionValue;
import com.azure.resourcemanager.cdn.models.UrlRewriteActionParameters;
import java.io.IOException;

public final class UrlRewriteAction
extends DeliveryRuleAction {
    private DeliveryRuleActionValue name = DeliveryRuleActionValue.URL_REWRITE;
    private UrlRewriteActionParameters parameters;
    private static final ClientLogger LOGGER = new ClientLogger(UrlRewriteAction.class);

    @Override
    public DeliveryRuleActionValue name() {
        return this.name;
    }

    public UrlRewriteActionParameters parameters() {
        return this.parameters;
    }

    public UrlRewriteAction withParameters(UrlRewriteActionParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.parameters() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property parameters in model UrlRewriteAction"));
        }
        this.parameters().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        return jsonWriter.writeEndObject();
    }

    public static UrlRewriteAction fromJson(JsonReader jsonReader) throws IOException {
        return (UrlRewriteAction)jsonReader.readObject(reader -> {
            UrlRewriteAction deserializedUrlRewriteAction = new UrlRewriteAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("parameters".equals(fieldName)) {
                    deserializedUrlRewriteAction.parameters = UrlRewriteActionParameters.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedUrlRewriteAction.name = DeliveryRuleActionValue.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUrlRewriteAction;
        });
    }
}

