/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.AfdOriginGroupProperties;
import com.azure.resourcemanager.cdn.models.AfdProvisioningState;
import com.azure.resourcemanager.cdn.models.DeploymentStatus;
import com.azure.resourcemanager.cdn.models.EnabledState;
import com.azure.resourcemanager.cdn.models.HealthProbeParameters;
import com.azure.resourcemanager.cdn.models.LoadBalancingSettingsParameters;
import java.io.IOException;

public final class AfdOriginGroupInner
extends ProxyResource {
    private AfdOriginGroupProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private AfdOriginGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public AfdProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public DeploymentStatus deploymentStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentStatus();
    }

    public String profileName() {
        return this.innerProperties() == null ? null : this.innerProperties().profileName();
    }

    public LoadBalancingSettingsParameters loadBalancingSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().loadBalancingSettings();
    }

    public AfdOriginGroupInner withLoadBalancingSettings(LoadBalancingSettingsParameters loadBalancingSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginGroupProperties();
        }
        this.innerProperties().withLoadBalancingSettings(loadBalancingSettings);
        return this;
    }

    public HealthProbeParameters healthProbeSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().healthProbeSettings();
    }

    public AfdOriginGroupInner withHealthProbeSettings(HealthProbeParameters healthProbeSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginGroupProperties();
        }
        this.innerProperties().withHealthProbeSettings(healthProbeSettings);
        return this;
    }

    public Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().trafficRestorationTimeToHealedOrNewEndpointsInMinutes();
    }

    public AfdOriginGroupInner withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(Integer trafficRestorationTimeToHealedOrNewEndpointsInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginGroupProperties();
        }
        this.innerProperties().withTrafficRestorationTimeToHealedOrNewEndpointsInMinutes(trafficRestorationTimeToHealedOrNewEndpointsInMinutes);
        return this;
    }

    public EnabledState sessionAffinityState() {
        return this.innerProperties() == null ? null : this.innerProperties().sessionAffinityState();
    }

    public AfdOriginGroupInner withSessionAffinityState(EnabledState sessionAffinityState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AfdOriginGroupProperties();
        }
        this.innerProperties().withSessionAffinityState(sessionAffinityState);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AfdOriginGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (AfdOriginGroupInner)((Object)jsonReader.readObject(reader -> {
            AfdOriginGroupInner deserializedAfdOriginGroupInner = new AfdOriginGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAfdOriginGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAfdOriginGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAfdOriginGroupInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAfdOriginGroupInner.innerProperties = AfdOriginGroupProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedAfdOriginGroupInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAfdOriginGroupInner;
        }));
    }
}

