/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.cdn.CdnManager;
import com.azure.resourcemanager.cdn.fluent.CdnManagementClient;
import com.azure.resourcemanager.cdn.fluent.models.CustomDomainInner;
import com.azure.resourcemanager.cdn.fluent.models.EndpointInner;
import com.azure.resourcemanager.cdn.implementation.CdnProfileImpl;
import com.azure.resourcemanager.cdn.implementation.CdnStandardRulesEngineRuleImpl;
import com.azure.resourcemanager.cdn.models.CdnEndpoint;
import com.azure.resourcemanager.cdn.models.CdnProfile;
import com.azure.resourcemanager.cdn.models.CustomDomainParameters;
import com.azure.resourcemanager.cdn.models.CustomDomainValidationResult;
import com.azure.resourcemanager.cdn.models.DeepCreatedOrigin;
import com.azure.resourcemanager.cdn.models.DeliveryRule;
import com.azure.resourcemanager.cdn.models.EndpointPropertiesUpdateParametersDeliveryPolicy;
import com.azure.resourcemanager.cdn.models.EndpointResourceState;
import com.azure.resourcemanager.cdn.models.EndpointUpdateParameters;
import com.azure.resourcemanager.cdn.models.GeoFilter;
import com.azure.resourcemanager.cdn.models.GeoFilterActions;
import com.azure.resourcemanager.cdn.models.OriginUpdateParameters;
import com.azure.resourcemanager.cdn.models.QueryStringCachingBehavior;
import com.azure.resourcemanager.cdn.models.ResourceUsage;
import com.azure.resourcemanager.cdn.models.SkuName;
import com.azure.resourcemanager.resources.fluentcore.arm.CountryIsoCode;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class CdnEndpointImpl
extends ExternalChildResourceImpl<CdnEndpoint, EndpointInner, CdnProfileImpl, CdnProfile>
implements CdnEndpoint,
CdnEndpoint.DefinitionStages.Blank.StandardEndpoint<CdnProfile.DefinitionStages.WithStandardCreate>,
CdnEndpoint.DefinitionStages.Blank.PremiumEndpoint<CdnProfile.DefinitionStages.WithPremiumVerizonCreate>,
CdnEndpoint.DefinitionStages.WithStandardAttach<CdnProfile.DefinitionStages.WithStandardCreate>,
CdnEndpoint.DefinitionStages.WithPremiumAttach<CdnProfile.DefinitionStages.WithPremiumVerizonCreate>,
CdnEndpoint.UpdateDefinitionStages.Blank.StandardEndpoint<CdnProfile.Update>,
CdnEndpoint.UpdateDefinitionStages.Blank.PremiumEndpoint<CdnProfile.Update>,
CdnEndpoint.UpdateDefinitionStages.WithStandardAttach<CdnProfile.Update>,
CdnEndpoint.UpdateDefinitionStages.WithPremiumAttach<CdnProfile.Update>,
CdnEndpoint.UpdateStandardEndpoint,
CdnEndpoint.UpdatePremiumEndpoint {
    private Set<String> customDomainHostnames;
    private Set<String> deletedCustomDomainHostnames;
    private final Map<String, DeliveryRule> standardRulesEngineRuleMap = new HashMap<String, DeliveryRule>();

    CdnEndpointImpl(String name, CdnProfileImpl parent, EndpointInner inner) {
        super(name, (Object)parent, (Object)inner);
        this.customDomainHostnames = new LinkedHashSet<String>();
        this.deletedCustomDomainHostnames = new HashSet<String>();
        this.initializeRuleMapForStandardMicrosoftSku();
    }

    public String id() {
        return ((EndpointInner)((Object)this.innerModel())).id();
    }

    public Mono<CdnEndpoint> createResourceAsync() {
        CdnEndpointImpl self = this;
        if (this.isStandardMicrosoftSku() && ((EndpointInner)((Object)this.innerModel())).deliveryPolicy() == null && this.standardRulesEngineRuleMap.size() > 0) {
            ((EndpointInner)((Object)this.innerModel())).withDeliveryPolicy(new EndpointPropertiesUpdateParametersDeliveryPolicy().withRules(this.standardRulesEngineRuleMap.values().stream().sorted(Comparator.comparingInt(DeliveryRule::order)).collect(Collectors.toList())));
        }
        return ((CdnManagementClient)((CdnManager)((CdnProfileImpl)this.parent()).manager()).serviceClient()).getEndpoints().createAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name(), (EndpointInner)((Object)this.innerModel())).flatMap(inner -> {
            self.setInner(inner);
            return Flux.fromIterable(self.customDomainHostnames).flatMapDelayError(customDomain -> ((CdnManagementClient)((CdnManager)((CdnProfileImpl)self.parent()).manager()).serviceClient()).getCustomDomains().createAsync(((CdnProfileImpl)self.parent()).resourceGroupName(), ((CdnProfileImpl)self.parent()).name(), self.name(), ((CdnManager)((CdnProfileImpl)self.parent()).manager()).resourceManager().internalContext().randomResourceName("CustomDomain", 50), new CustomDomainParameters().withHostname((String)customDomain)), 32, 32).then(((CdnManagementClient)((CdnManager)((CdnProfileImpl)self.parent()).manager()).serviceClient()).getCustomDomains().listByEndpointAsync(((CdnProfileImpl)self.parent()).resourceGroupName(), ((CdnProfileImpl)self.parent()).name(), self.name()).collectList().map(customDomainInners -> {
                self.customDomainHostnames.addAll(customDomainInners.stream().map(CustomDomainInner::hostname).collect(Collectors.toSet()));
                return self;
            }));
        });
    }

    public Mono<CdnEndpoint> updateResourceAsync() {
        CdnEndpointImpl self = this;
        EndpointUpdateParameters endpointUpdateParameters = new EndpointUpdateParameters();
        endpointUpdateParameters.withIsHttpAllowed(((EndpointInner)((Object)this.innerModel())).isHttpAllowed()).withIsHttpsAllowed(((EndpointInner)((Object)this.innerModel())).isHttpsAllowed()).withOriginPath(((EndpointInner)((Object)this.innerModel())).originPath()).withOriginHostHeader(((EndpointInner)((Object)this.innerModel())).originHostHeader()).withIsCompressionEnabled(((EndpointInner)((Object)this.innerModel())).isCompressionEnabled()).withContentTypesToCompress(((EndpointInner)((Object)this.innerModel())).contentTypesToCompress()).withGeoFilters(((EndpointInner)((Object)this.innerModel())).geoFilters()).withOptimizationType(((EndpointInner)((Object)this.innerModel())).optimizationType()).withQueryStringCachingBehavior(((EndpointInner)((Object)this.innerModel())).queryStringCachingBehavior()).withTags(((EndpointInner)((Object)this.innerModel())).tags());
        if (this.isStandardMicrosoftSku()) {
            List<DeliveryRule> rules = this.standardRulesEngineRuleMap.values().stream().sorted(Comparator.comparingInt(DeliveryRule::order)).collect(Collectors.toList());
            this.ensureDeliveryPolicy();
            endpointUpdateParameters.withDeliveryPolicy(new EndpointPropertiesUpdateParametersDeliveryPolicy().withRules(rules));
        }
        DeepCreatedOrigin originInner = ((EndpointInner)((Object)this.innerModel())).origins().get(0);
        OriginUpdateParameters originUpdateParameters = new OriginUpdateParameters().withHostname(originInner.hostname()).withHttpPort(originInner.httpPort()).withHttpsPort(originInner.httpsPort());
        Mono originUpdateTask = ((CdnManagementClient)((CdnManager)((CdnProfileImpl)this.parent()).manager()).serviceClient()).getOrigins().updateAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name(), originInner.name(), originUpdateParameters).then(Mono.empty());
        Mono<EndpointInner> endpointUpdateTask = ((CdnManagementClient)((CdnManager)((CdnProfileImpl)this.parent()).manager()).serviceClient()).getEndpoints().updateAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name(), endpointUpdateParameters);
        Flux customDomainCreateTask = Flux.fromIterable(this.customDomainHostnames).flatMapDelayError(itemToCreate -> ((CdnManagementClient)((CdnManager)((CdnProfileImpl)this.parent()).manager()).serviceClient()).getCustomDomains().createAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name(), ((CdnManager)((CdnProfileImpl)self.parent()).manager()).resourceManager().internalContext().randomResourceName("CustomDomain", 50), new CustomDomainParameters().withHostname((String)itemToCreate)), 32, 32);
        Flux customDomainDeleteTask = this.deletedCustomDomainHostnames.isEmpty() ? Flux.empty() : ((CdnManagementClient)((CdnManager)((CdnProfileImpl)this.parent()).manager()).serviceClient()).getCustomDomains().listByEndpointAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name()).filter(customDomain -> this.deletedCustomDomainHostnames.contains(customDomain.hostname())).flatMapDelayError(itemToDelete -> ((CdnManagementClient)((CdnManager)((CdnProfileImpl)this.parent()).manager()).serviceClient()).getCustomDomains().deleteAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name(), itemToDelete.name()), 32, 32);
        Mono customDomainTask = Flux.concat((Publisher[])new Publisher[]{customDomainCreateTask, customDomainDeleteTask}).then(Mono.empty());
        return Flux.mergeDelayError((int)32, (Publisher[])new Publisher[]{customDomainTask, originUpdateTask, endpointUpdateTask}).last().map(inner -> {
            self.setInner(inner);
            self.customDomainHostnames.clear();
            self.deletedCustomDomainHostnames.clear();
            return self;
        });
    }

    public Mono<Void> deleteResourceAsync() {
        return ((CdnManagementClient)((CdnManager)((CdnProfileImpl)this.parent()).manager()).serviceClient()).getEndpoints().deleteAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name());
    }

    public Mono<CdnEndpoint> refreshAsync() {
        CdnEndpointImpl self = this;
        return super.refreshAsync().flatMap(cdnEndpoint -> {
            self.customDomainHostnames.clear();
            self.deletedCustomDomainHostnames.clear();
            this.initializeRuleMapForStandardMicrosoftSku();
            return ((CdnManagementClient)((CdnManager)((CdnProfileImpl)self.parent()).manager()).serviceClient()).getCustomDomains().listByEndpointAsync(((CdnProfileImpl)self.parent()).resourceGroupName(), ((CdnProfileImpl)self.parent()).name(), self.name()).collectList().map(customDomainInners -> {
                self.customDomainHostnames.addAll(customDomainInners.stream().map(CustomDomainInner::hostname).collect(Collectors.toSet()));
                return self;
            });
        });
    }

    protected Mono<EndpointInner> getInnerAsync() {
        return ((CdnManagementClient)((CdnManager)((CdnProfileImpl)this.parent()).manager()).serviceClient()).getEndpoints().getAsync(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name());
    }

    @Override
    public PagedIterable<ResourceUsage> listResourceUsage() {
        return PagedConverter.mapPage(((CdnManagementClient)((CdnManager)((CdnProfileImpl)this.parent()).manager()).serviceClient()).getEndpoints().listResourceUsage(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name()), ResourceUsage::new);
    }

    @Override
    public Map<String, DeliveryRule> standardRulesEngineRules() {
        return Collections.unmodifiableMap(this.standardRulesEngineRuleMap);
    }

    @Override
    public CdnProfileImpl attach() {
        return (CdnProfileImpl)this.parent();
    }

    @Override
    public String originHostHeader() {
        return ((EndpointInner)((Object)this.innerModel())).originHostHeader();
    }

    @Override
    public String originPath() {
        return ((EndpointInner)((Object)this.innerModel())).originPath();
    }

    @Override
    public Set<String> contentTypesToCompress() {
        List<String> contentTypes = ((EndpointInner)((Object)this.innerModel())).contentTypesToCompress();
        HashSet<String> set = new HashSet<String>();
        if (contentTypes != null) {
            set.addAll(contentTypes);
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public boolean isCompressionEnabled() {
        return ((EndpointInner)((Object)this.innerModel())).isCompressionEnabled();
    }

    @Override
    public boolean isHttpAllowed() {
        return ((EndpointInner)((Object)this.innerModel())).isHttpAllowed();
    }

    @Override
    public boolean isHttpsAllowed() {
        return ((EndpointInner)((Object)this.innerModel())).isHttpsAllowed();
    }

    @Override
    public QueryStringCachingBehavior queryStringCachingBehavior() {
        return ((EndpointInner)((Object)this.innerModel())).queryStringCachingBehavior();
    }

    @Override
    public String optimizationType() {
        if (((EndpointInner)((Object)this.innerModel())).optimizationType() == null) {
            return null;
        }
        return ((EndpointInner)((Object)this.innerModel())).optimizationType().toString();
    }

    public List<GeoFilter> geoFilters() {
        return ((EndpointInner)((Object)this.innerModel())).geoFilters();
    }

    @Override
    public String hostname() {
        return ((EndpointInner)((Object)this.innerModel())).hostname();
    }

    @Override
    public EndpointResourceState resourceState() {
        return ((EndpointInner)((Object)this.innerModel())).resourceState();
    }

    @Override
    public String provisioningState() {
        return ((EndpointInner)((Object)this.innerModel())).provisioningState() == null ? null : ((EndpointInner)((Object)this.innerModel())).provisioningState().toString();
    }

    @Override
    public String originHostName() {
        if (((EndpointInner)((Object)this.innerModel())).origins() != null && !((EndpointInner)((Object)this.innerModel())).origins().isEmpty()) {
            return ((EndpointInner)((Object)this.innerModel())).origins().get(0).hostname();
        }
        return null;
    }

    @Override
    public int httpPort() {
        if (((EndpointInner)((Object)this.innerModel())).origins() != null && !((EndpointInner)((Object)this.innerModel())).origins().isEmpty()) {
            Integer httpPort = ((EndpointInner)((Object)this.innerModel())).origins().get(0).httpPort();
            return httpPort != null ? httpPort : 0;
        }
        return 0;
    }

    @Override
    public int httpsPort() {
        if (((EndpointInner)((Object)this.innerModel())).origins() != null && !((EndpointInner)((Object)this.innerModel())).origins().isEmpty()) {
            Integer httpsPort = ((EndpointInner)((Object)this.innerModel())).origins().get(0).httpsPort();
            return httpsPort != null ? httpsPort : 0;
        }
        return 0;
    }

    @Override
    public Set<String> customDomains() {
        HashSet<String> set = new HashSet<String>();
        for (CustomDomainInner customDomainInner : ((CdnManagementClient)((CdnManager)((CdnProfileImpl)this.parent()).manager()).serviceClient()).getCustomDomains().listByEndpoint(((CdnProfileImpl)this.parent()).resourceGroupName(), ((CdnProfileImpl)this.parent()).name(), this.name())) {
            set.add(customDomainInner.hostname());
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public void start() {
        ((CdnProfileImpl)this.parent()).startEndpoint(this.name());
    }

    @Override
    public Mono<Void> startAsync() {
        return ((CdnProfileImpl)this.parent()).startEndpointAsync(this.name());
    }

    @Override
    public void stop() {
        this.stopAsync().block();
    }

    @Override
    public Mono<Void> stopAsync() {
        return ((CdnProfileImpl)this.parent()).stopEndpointAsync(this.name());
    }

    @Override
    public void purgeContent(Set<String> contentPaths) {
        if (contentPaths != null) {
            this.purgeContentAsync(contentPaths).block();
        }
    }

    @Override
    public Mono<Void> purgeContentAsync(Set<String> contentPaths) {
        return ((CdnProfileImpl)this.parent()).purgeEndpointContentAsync(this.name(), contentPaths);
    }

    @Override
    public void loadContent(Set<String> contentPaths) {
        this.loadContentAsync(contentPaths).block();
    }

    @Override
    public Mono<Void> loadContentAsync(Set<String> contentPaths) {
        return ((CdnProfileImpl)this.parent()).loadEndpointContentAsync(this.name(), contentPaths);
    }

    @Override
    public CustomDomainValidationResult validateCustomDomain(String hostName) {
        return (CustomDomainValidationResult)this.validateCustomDomainAsync(hostName).block();
    }

    @Override
    public Mono<CustomDomainValidationResult> validateCustomDomainAsync(String hostName) {
        return ((CdnProfileImpl)this.parent()).validateEndpointCustomDomainAsync(this.name(), hostName);
    }

    public CdnEndpointImpl withOrigin(String originName, String hostname) {
        ((EndpointInner)((Object)this.innerModel())).origins().add(new DeepCreatedOrigin().withName(originName).withHostname(hostname));
        return this;
    }

    public CdnEndpointImpl withOrigin(String hostname) {
        return this.withOrigin("origin", hostname);
    }

    public CdnEndpointImpl withPremiumOrigin(String originName, String hostname) {
        return this.withOrigin(originName, hostname);
    }

    public CdnEndpointImpl withPremiumOrigin(String hostname) {
        return this.withOrigin(hostname);
    }

    @Override
    public CdnEndpointImpl withOriginPath(String originPath) {
        ((EndpointInner)((Object)this.innerModel())).withOriginPath(originPath);
        return this;
    }

    @Override
    public CdnEndpointImpl withHttpAllowed(boolean httpAllowed) {
        ((EndpointInner)((Object)this.innerModel())).withIsHttpAllowed(httpAllowed);
        return this;
    }

    @Override
    public CdnEndpointImpl withHttpsAllowed(boolean httpsAllowed) {
        ((EndpointInner)((Object)this.innerModel())).withIsHttpsAllowed(httpsAllowed);
        return this;
    }

    @Override
    public CdnEndpointImpl withHttpPort(int httpPort) {
        if (((EndpointInner)((Object)this.innerModel())).origins() != null && !((EndpointInner)((Object)this.innerModel())).origins().isEmpty()) {
            ((EndpointInner)((Object)this.innerModel())).origins().get(0).withHttpPort(httpPort);
        }
        return this;
    }

    @Override
    public CdnEndpointImpl withHttpsPort(int httpsPort) {
        if (((EndpointInner)((Object)this.innerModel())).origins() != null && !((EndpointInner)((Object)this.innerModel())).origins().isEmpty()) {
            ((EndpointInner)((Object)this.innerModel())).origins().get(0).withHttpsPort(httpsPort);
        }
        return this;
    }

    @Override
    public CdnEndpointImpl withHostHeader(String hostHeader) {
        ((EndpointInner)((Object)this.innerModel())).withOriginHostHeader(hostHeader);
        return this;
    }

    @Override
    public CdnEndpointImpl withContentTypesToCompress(Set<String> contentTypesToCompress) {
        ArrayList<String> list = null;
        if (contentTypesToCompress != null) {
            list = new ArrayList<String>(contentTypesToCompress);
        }
        ((EndpointInner)((Object)this.innerModel())).withContentTypesToCompress(list);
        return this;
    }

    @Override
    public CdnEndpointImpl withoutContentTypesToCompress() {
        if (((EndpointInner)((Object)this.innerModel())).contentTypesToCompress() != null) {
            ((EndpointInner)((Object)this.innerModel())).contentTypesToCompress().clear();
        }
        return this;
    }

    @Override
    public CdnEndpointImpl withContentTypeToCompress(String contentTypeToCompress) {
        if (((EndpointInner)((Object)this.innerModel())).contentTypesToCompress() == null) {
            ((EndpointInner)((Object)this.innerModel())).withContentTypesToCompress(new ArrayList<String>());
        }
        ((EndpointInner)((Object)this.innerModel())).contentTypesToCompress().add(contentTypeToCompress);
        return this;
    }

    @Override
    public CdnEndpointImpl withoutContentTypeToCompress(String contentTypeToCompress) {
        if (((EndpointInner)((Object)this.innerModel())).contentTypesToCompress() != null) {
            ((EndpointInner)((Object)this.innerModel())).contentTypesToCompress().remove(contentTypeToCompress);
        }
        return this;
    }

    @Override
    public CdnEndpointImpl withCompressionEnabled(boolean compressionEnabled) {
        ((EndpointInner)((Object)this.innerModel())).withIsCompressionEnabled(compressionEnabled);
        return this;
    }

    @Override
    public CdnEndpointImpl withQueryStringCachingBehavior(QueryStringCachingBehavior cachingBehavior) {
        ((EndpointInner)((Object)this.innerModel())).withQueryStringCachingBehavior(cachingBehavior);
        return this;
    }

    @Override
    public CdnEndpointImpl withGeoFilters(Collection<GeoFilter> geoFilters) {
        ArrayList<GeoFilter> list = null;
        if (geoFilters != null) {
            list = new ArrayList<GeoFilter>(geoFilters);
        }
        ((EndpointInner)((Object)this.innerModel())).withGeoFilters(list);
        return this;
    }

    @Override
    public CdnEndpointImpl withoutGeoFilters() {
        if (((EndpointInner)((Object)this.innerModel())).geoFilters() != null) {
            ((EndpointInner)((Object)this.innerModel())).geoFilters().clear();
        }
        return this;
    }

    @Override
    public CdnEndpointImpl withGeoFilter(String relativePath, GeoFilterActions action, CountryIsoCode countryCode) {
        GeoFilter geoFilter = this.createGeoFiltersObject(relativePath, action);
        if (geoFilter.countryCodes() == null) {
            geoFilter.withCountryCodes(new ArrayList<String>());
        }
        geoFilter.countryCodes().add(countryCode.toString());
        ((EndpointInner)((Object)this.innerModel())).geoFilters().add(geoFilter);
        return this;
    }

    @Override
    public CdnEndpointImpl withGeoFilter(String relativePath, GeoFilterActions action, Collection<CountryIsoCode> countryCodes) {
        GeoFilter geoFilter = this.createGeoFiltersObject(relativePath, action);
        if (geoFilter.countryCodes() == null) {
            geoFilter.withCountryCodes(new ArrayList<String>());
        } else {
            geoFilter.countryCodes().clear();
        }
        for (CountryIsoCode countryCode : countryCodes) {
            geoFilter.countryCodes().add(countryCode.toString());
        }
        ((EndpointInner)((Object)this.innerModel())).geoFilters().add(geoFilter);
        return this;
    }

    @Override
    public CdnEndpointImpl withoutGeoFilter(String relativePath) {
        ((EndpointInner)((Object)this.innerModel())).geoFilters().removeIf(geoFilter -> geoFilter.relativePath().equals(relativePath));
        return this;
    }

    @Override
    public CdnEndpointImpl withCustomDomain(String hostName) {
        this.customDomainHostnames.add(hostName);
        return this;
    }

    public CdnStandardRulesEngineRuleImpl defineNewStandardRulesEngineRule(String name) {
        this.throwIfNotStandardMicrosoftSku();
        CdnStandardRulesEngineRuleImpl deliveryRule = new CdnStandardRulesEngineRuleImpl(this, name);
        this.standardRulesEngineRuleMap.put(name, (DeliveryRule)deliveryRule.innerModel());
        return deliveryRule;
    }

    public CdnStandardRulesEngineRuleImpl updateStandardRulesEngineRule(String name) {
        this.throwIfNotStandardMicrosoftSku();
        return new CdnStandardRulesEngineRuleImpl(this, this.standardRulesEngineRules().get(name));
    }

    @Override
    public CdnEndpointImpl withoutStandardRulesEngineRule(String name) {
        this.throwIfNotStandardMicrosoftSku();
        this.standardRulesEngineRuleMap.remove(name);
        return this;
    }

    @Override
    public CdnEndpointImpl withoutCustomDomain(String hostName) {
        this.deletedCustomDomainHostnames.add(hostName);
        return this;
    }

    private GeoFilter createGeoFiltersObject(String relativePath, GeoFilterActions action) {
        if (((EndpointInner)((Object)this.innerModel())).geoFilters() == null) {
            ((EndpointInner)((Object)this.innerModel())).withGeoFilters(new ArrayList<GeoFilter>());
        }
        GeoFilter geoFilter = null;
        for (GeoFilter filter : ((EndpointInner)((Object)this.innerModel())).geoFilters()) {
            if (!filter.relativePath().equals(relativePath)) continue;
            geoFilter = filter;
            break;
        }
        if (geoFilter == null) {
            geoFilter = new GeoFilter();
        } else {
            ((EndpointInner)((Object)this.innerModel())).geoFilters().remove(geoFilter);
        }
        geoFilter.withRelativePath(relativePath).withAction(action);
        return geoFilter;
    }

    private void initializeRuleMapForStandardMicrosoftSku() {
        this.standardRulesEngineRuleMap.clear();
        if (this.isStandardMicrosoftSku() && ((EndpointInner)((Object)this.innerModel())).deliveryPolicy() != null && ((EndpointInner)((Object)this.innerModel())).deliveryPolicy().rules() != null) {
            for (DeliveryRule rule : ((EndpointInner)((Object)this.innerModel())).deliveryPolicy().rules()) {
                this.standardRulesEngineRuleMap.put(rule.name(), rule);
            }
        }
    }

    private boolean isStandardMicrosoftSku() {
        return SkuName.STANDARD_MICROSOFT.equals((Object)((CdnProfileImpl)this.parent()).sku().name());
    }

    private void throwIfNotStandardMicrosoftSku() {
        if (!this.isStandardMicrosoftSku()) {
            throw new IllegalStateException(String.format("Standard rules engine only supports for Standard Microsoft SKU, current SKU is %s", new Object[]{((CdnProfileImpl)this.parent()).sku().name()}));
        }
    }

    private void ensureDeliveryPolicy() {
        if (((EndpointInner)((Object)this.innerModel())).deliveryPolicy() == null) {
            ((EndpointInner)((Object)this.innerModel())).withDeliveryPolicy(new EndpointPropertiesUpdateParametersDeliveryPolicy());
        }
    }
}

