// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.fluent.models.EdgeNodeInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list CDN edgenodes. It contains a list of ip address group and a URL link to get the next
 * set of results.
 */
@Fluent
public final class EdgenodeResult implements JsonSerializable<EdgenodeResult> {
    /*
     * Edge node of CDN service.
     */
    private List<EdgeNodeInner> value;

    /*
     * URL to get the next set of edgenode list results if there are any.
     */
    private String nextLink;

    /**
     * Creates an instance of EdgenodeResult class.
     */
    public EdgenodeResult() {
    }

    /**
     * Get the value property: Edge node of CDN service.
     * 
     * @return the value value.
     */
    public List<EdgeNodeInner> value() {
        return this.value;
    }

    /**
     * Get the nextLink property: URL to get the next set of edgenode list results if there are any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of edgenode list results if there are any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the EdgenodeResult object itself.
     */
    public EdgenodeResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EdgenodeResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EdgenodeResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the EdgenodeResult.
     */
    public static EdgenodeResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EdgenodeResult deserializedEdgenodeResult = new EdgenodeResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<EdgeNodeInner> value = reader.readArray(reader1 -> EdgeNodeInner.fromJson(reader1));
                    deserializedEdgenodeResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedEdgenodeResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEdgenodeResult;
        });
    }
}
