// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Parameters required for profile upgrade.
 */
@Fluent
public final class ProfileUpgradeParameters implements JsonSerializable<ProfileUpgradeParameters> {
    /*
     * Web Application Firewall (WAF) and security policy mapping for the profile upgrade
     */
    private List<ProfileChangeSkuWafMapping> wafMappingList;

    /**
     * Creates an instance of ProfileUpgradeParameters class.
     */
    public ProfileUpgradeParameters() {
    }

    /**
     * Get the wafMappingList property: Web Application Firewall (WAF) and security policy mapping for the profile
     * upgrade.
     * 
     * @return the wafMappingList value.
     */
    public List<ProfileChangeSkuWafMapping> wafMappingList() {
        return this.wafMappingList;
    }

    /**
     * Set the wafMappingList property: Web Application Firewall (WAF) and security policy mapping for the profile
     * upgrade.
     * 
     * @param wafMappingList the wafMappingList value to set.
     * @return the ProfileUpgradeParameters object itself.
     */
    public ProfileUpgradeParameters withWafMappingList(List<ProfileChangeSkuWafMapping> wafMappingList) {
        this.wafMappingList = wafMappingList;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (wafMappingList() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property wafMappingList in model ProfileUpgradeParameters"));
        } else {
            wafMappingList().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ProfileUpgradeParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("wafMappingList", this.wafMappingList,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProfileUpgradeParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProfileUpgradeParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ProfileUpgradeParameters.
     */
    public static ProfileUpgradeParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProfileUpgradeParameters deserializedProfileUpgradeParameters = new ProfileUpgradeParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("wafMappingList".equals(fieldName)) {
                    List<ProfileChangeSkuWafMapping> wafMappingList
                        = reader.readArray(reader1 -> ProfileChangeSkuWafMapping.fromJson(reader1));
                    deserializedProfileUpgradeParameters.wafMappingList = wafMappingList;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProfileUpgradeParameters;
        });
    }
}
