/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.cdn.models.ResourceReference;
import com.azure.resourcemanager.cdn.models.SharedPrivateLinkResourceStatus;
import java.io.IOException;

public final class SharedPrivateLinkResourceProperties
implements JsonSerializable<SharedPrivateLinkResourceProperties> {
    private ResourceReference privateLink;
    private String privateLinkLocation;
    private String groupId;
    private String requestMessage;
    private SharedPrivateLinkResourceStatus status;

    public ResourceReference privateLink() {
        return this.privateLink;
    }

    public SharedPrivateLinkResourceProperties withPrivateLink(ResourceReference privateLink) {
        this.privateLink = privateLink;
        return this;
    }

    public String privateLinkLocation() {
        return this.privateLinkLocation;
    }

    public SharedPrivateLinkResourceProperties withPrivateLinkLocation(String privateLinkLocation) {
        this.privateLinkLocation = privateLinkLocation;
        return this;
    }

    public String groupId() {
        return this.groupId;
    }

    public SharedPrivateLinkResourceProperties withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String requestMessage() {
        return this.requestMessage;
    }

    public SharedPrivateLinkResourceProperties withRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
        return this;
    }

    public SharedPrivateLinkResourceStatus status() {
        return this.status;
    }

    public SharedPrivateLinkResourceProperties withStatus(SharedPrivateLinkResourceStatus status) {
        this.status = status;
        return this;
    }

    public void validate() {
        if (this.privateLink() != null) {
            this.privateLink().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateLink", (JsonSerializable)this.privateLink);
        jsonWriter.writeStringField("privateLinkLocation", this.privateLinkLocation);
        jsonWriter.writeStringField("groupId", this.groupId);
        jsonWriter.writeStringField("requestMessage", this.requestMessage);
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    public static SharedPrivateLinkResourceProperties fromJson(JsonReader jsonReader) throws IOException {
        return (SharedPrivateLinkResourceProperties)jsonReader.readObject(reader -> {
            SharedPrivateLinkResourceProperties deserializedSharedPrivateLinkResourceProperties = new SharedPrivateLinkResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateLink".equals(fieldName)) {
                    deserializedSharedPrivateLinkResourceProperties.privateLink = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("privateLinkLocation".equals(fieldName)) {
                    deserializedSharedPrivateLinkResourceProperties.privateLinkLocation = reader.getString();
                    continue;
                }
                if ("groupId".equals(fieldName)) {
                    deserializedSharedPrivateLinkResourceProperties.groupId = reader.getString();
                    continue;
                }
                if ("requestMessage".equals(fieldName)) {
                    deserializedSharedPrivateLinkResourceProperties.requestMessage = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSharedPrivateLinkResourceProperties.status = SharedPrivateLinkResourceStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSharedPrivateLinkResourceProperties;
        });
    }
}

