/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.cdn.fluent.AfdOriginsClient;
import com.azure.resourcemanager.cdn.fluent.models.AfdOriginInner;
import com.azure.resourcemanager.cdn.implementation.CdnManagementClientImpl;
import com.azure.resourcemanager.cdn.models.AfdOriginListResult;
import com.azure.resourcemanager.cdn.models.AfdOriginUpdateParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AfdOriginsClientImpl
implements AfdOriginsClient {
    private final ClientLogger logger = new ClientLogger(AfdOriginsClientImpl.class);
    private final AfdOriginsService service;
    private final CdnManagementClientImpl client;

    AfdOriginsClientImpl(CdnManagementClientImpl client) {
        this.service = (AfdOriginsService)RestProxy.create(AfdOriginsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AfdOriginInner>> listByOriginGroupSinglePageAsync(String resourceGroupName, String profileName, String originGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByOriginGroup(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AfdOriginListResult)res.getValue()).value(), ((AfdOriginListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AfdOriginInner>> listByOriginGroupSinglePageAsync(String resourceGroupName, String profileName, String originGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByOriginGroup(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AfdOriginListResult)res.getValue()).value(), ((AfdOriginListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<AfdOriginInner> listByOriginGroupAsync(String resourceGroupName, String profileName, String originGroupName) {
        return new PagedFlux(() -> this.listByOriginGroupSinglePageAsync(resourceGroupName, profileName, originGroupName), nextLink -> this.listByOriginGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<AfdOriginInner> listByOriginGroupAsync(String resourceGroupName, String profileName, String originGroupName, Context context) {
        return new PagedFlux(() -> this.listByOriginGroupSinglePageAsync(resourceGroupName, profileName, originGroupName, context), nextLink -> this.listByOriginGroupNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AfdOriginInner> listByOriginGroup(String resourceGroupName, String profileName, String originGroupName) {
        return new PagedIterable(this.listByOriginGroupAsync(resourceGroupName, profileName, originGroupName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<AfdOriginInner> listByOriginGroup(String resourceGroupName, String profileName, String originGroupName, Context context) {
        return new PagedIterable(this.listByOriginGroupAsync(resourceGroupName, profileName, originGroupName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AfdOriginInner>> getWithResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName, originName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<AfdOriginInner>> getWithResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName, originName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AfdOriginInner> getAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        return this.getWithResponseAsync(resourceGroupName, profileName, originGroupName, originName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((AfdOriginInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AfdOriginInner get(String resourceGroupName, String profileName, String originGroupName, String originName) {
        return (AfdOriginInner)((Object)this.getAsync(resourceGroupName, profileName, originGroupName, originName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AfdOriginInner> getWithResponse(String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, profileName, originGroupName, originName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (origin == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter origin is required and cannot be null."));
        }
        origin.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName, originName, this.client.getSubscriptionId(), this.client.getApiVersion(), origin, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (origin == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter origin is required and cannot be null."));
        }
        origin.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName, originName, this.client.getSubscriptionId(), this.client.getApiVersion(), origin, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<AfdOriginInner>, AfdOriginInner> beginCreateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AfdOriginInner.class), (Type)((Object)AfdOriginInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<AfdOriginInner>, AfdOriginInner> beginCreateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createWithResponseAsync(resourceGroupName, profileName, originGroupName, originName, origin, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AfdOriginInner.class), (Type)((Object)AfdOriginInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<AfdOriginInner>, AfdOriginInner> beginCreate(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin) {
        return this.beginCreateAsync(resourceGroupName, profileName, originGroupName, originName, origin).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<AfdOriginInner>, AfdOriginInner> beginCreate(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, originGroupName, originName, origin, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AfdOriginInner> createAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin) {
        return this.beginCreateAsync(resourceGroupName, profileName, originGroupName, originName, origin).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AfdOriginInner> createAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin, Context context) {
        return this.beginCreateAsync(resourceGroupName, profileName, originGroupName, originName, origin, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AfdOriginInner create(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin) {
        return (AfdOriginInner)((Object)this.createAsync(resourceGroupName, profileName, originGroupName, originName, origin).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AfdOriginInner create(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginInner origin, Context context) {
        return (AfdOriginInner)((Object)this.createAsync(resourceGroupName, profileName, originGroupName, originName, origin, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginUpdateParameters originUpdateProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (originUpdateProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originUpdateProperties is required and cannot be null."));
        }
        originUpdateProperties.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName, originName, this.client.getSubscriptionId(), this.client.getApiVersion(), originUpdateProperties, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginUpdateParameters originUpdateProperties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (originUpdateProperties == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originUpdateProperties is required and cannot be null."));
        }
        originUpdateProperties.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName, originName, this.client.getSubscriptionId(), this.client.getApiVersion(), originUpdateProperties, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<AfdOriginInner>, AfdOriginInner> beginUpdateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginUpdateParameters originUpdateProperties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AfdOriginInner.class), (Type)((Object)AfdOriginInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<AfdOriginInner>, AfdOriginInner> beginUpdateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginUpdateParameters originUpdateProperties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AfdOriginInner.class), (Type)((Object)AfdOriginInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<AfdOriginInner>, AfdOriginInner> beginUpdate(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginUpdateParameters originUpdateProperties) {
        return this.beginUpdateAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<AfdOriginInner>, AfdOriginInner> beginUpdate(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginUpdateParameters originUpdateProperties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AfdOriginInner> updateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginUpdateParameters originUpdateProperties) {
        return this.beginUpdateAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AfdOriginInner> updateAsync(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginUpdateParameters originUpdateProperties, Context context) {
        return this.beginUpdateAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AfdOriginInner update(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginUpdateParameters originUpdateProperties) {
        return (AfdOriginInner)((Object)this.updateAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AfdOriginInner update(String resourceGroupName, String profileName, String originGroupName, String originName, AfdOriginUpdateParameters originUpdateProperties, Context context) {
        return (AfdOriginInner)((Object)this.updateAsync(resourceGroupName, profileName, originGroupName, originName, originUpdateProperties, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName, originName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (originGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originGroupName is required and cannot be null."));
        }
        if (originName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter originName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, profileName, originGroupName, originName, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, originGroupName, originName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, profileName, originGroupName, originName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String originGroupName, String originName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, originGroupName, originName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, originGroupName, originName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String profileName, String originGroupName, String originName) {
        return this.beginDeleteAsync(resourceGroupName, profileName, originGroupName, originName).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, profileName, originGroupName, originName, context).last().flatMap(arg_0 -> ((CdnManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String originGroupName, String originName) {
        this.deleteAsync(resourceGroupName, profileName, originGroupName, originName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String originGroupName, String originName, Context context) {
        this.deleteAsync(resourceGroupName, profileName, originGroupName, originName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AfdOriginInner>> listByOriginGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByOriginGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AfdOriginListResult)res.getValue()).value(), ((AfdOriginListResult)res.getValue()).nextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<AfdOriginInner>> listByOriginGroupNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByOriginGroupNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((AfdOriginListResult)res.getValue()).value(), ((AfdOriginListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="CdnManagementClientA")
    private static interface AfdOriginsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AfdOriginListResult>> listByOriginGroup(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="originGroupName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AfdOriginInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="originGroupName") String var4, @PathParam(value="originName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> create(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="originGroupName") String var4, @PathParam(value="originName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") AfdOriginInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="originGroupName") String var4, @PathParam(value="originName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") AfdOriginUpdateParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles/{profileName}/originGroups/{originGroupName}/origins/{originName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="profileName") String var3, @PathParam(value="originGroupName") String var4, @PathParam(value="originName") String var5, @PathParam(value="subscriptionId") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AfdOriginListResult>> listByOriginGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

