// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.cdn.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.cdn.fluent.EndpointsClient;
import com.azure.resourcemanager.cdn.fluent.models.EndpointInner;
import com.azure.resourcemanager.cdn.fluent.models.ResourceUsageInner;
import com.azure.resourcemanager.cdn.fluent.models.ValidateCustomDomainOutputInner;
import com.azure.resourcemanager.cdn.models.EndpointListResult;
import com.azure.resourcemanager.cdn.models.EndpointUpdateParameters;
import com.azure.resourcemanager.cdn.models.LoadParameters;
import com.azure.resourcemanager.cdn.models.PurgeParameters;
import com.azure.resourcemanager.cdn.models.ResourceUsageListResult;
import com.azure.resourcemanager.cdn.models.ValidateCustomDomainInput;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in EndpointsClient. */
public final class EndpointsClientImpl implements EndpointsClient {
    private final ClientLogger logger = new ClientLogger(EndpointsClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final EndpointsService service;

    /** The service client containing this operation class. */
    private final CdnManagementClientImpl client;

    /**
     * Initializes an instance of EndpointsClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    EndpointsClientImpl(CdnManagementClientImpl client) {
        this.service =
            RestProxy.create(EndpointsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for CdnManagementClientEndpoints to be used by the proxy service to
     * perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "CdnManagementClientE")
    private interface EndpointsService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/endpoints")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<EndpointListResult>> listByProfile(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/endpoints/{endpointName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<EndpointInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("endpointName") String endpointName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Put(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/endpoints/{endpointName}")
        @ExpectedResponses({200, 201, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> create(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("endpointName") String endpointName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") EndpointInner endpointParam,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Patch(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/endpoints/{endpointName}")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> update(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("endpointName") String endpointName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") EndpointUpdateParameters endpointUpdateProperties,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/endpoints/{endpointName}")
        @ExpectedResponses({202, 204})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("endpointName") String endpointName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/endpoints/{endpointName}/start")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> start(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("endpointName") String endpointName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/endpoints/{endpointName}/stop")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> stop(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("endpointName") String endpointName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/endpoints/{endpointName}/purge")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> purgeContent(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("endpointName") String endpointName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") PurgeParameters contentFilePaths,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/endpoints/{endpointName}/load")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<Flux<ByteBuffer>>> loadContent(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("endpointName") String endpointName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") LoadParameters contentFilePaths,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/endpoints/{endpointName}/validateCustomDomain")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ValidateCustomDomainOutputInner>> validateCustomDomain(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("endpointName") String endpointName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") ValidateCustomDomainInput customDomainProperties,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/profiles"
                + "/{profileName}/endpoints/{endpointName}/checkResourceUsage")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ResourceUsageListResult>> listResourceUsage(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("profileName") String profileName,
            @PathParam("endpointName") String endpointName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<EndpointListResult>> listByProfileNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ResourceUsageListResult>> listResourceUsageNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list endpoints.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<EndpointInner>> listByProfileSinglePageAsync(
        String resourceGroupName, String profileName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listByProfile(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<EndpointInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list endpoints.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<EndpointInner>> listByProfileSinglePageAsync(
        String resourceGroupName, String profileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByProfile(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list endpoints.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<EndpointInner> listByProfileAsync(String resourceGroupName, String profileName) {
        return new PagedFlux<>(
            () -> listByProfileSinglePageAsync(resourceGroupName, profileName),
            nextLink -> listByProfileNextSinglePageAsync(nextLink));
    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list endpoints.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<EndpointInner> listByProfileAsync(String resourceGroupName, String profileName, Context context) {
        return new PagedFlux<>(
            () -> listByProfileSinglePageAsync(resourceGroupName, profileName, context),
            nextLink -> listByProfileNextSinglePageAsync(nextLink, context));
    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list endpoints.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<EndpointInner> listByProfile(String resourceGroupName, String profileName) {
        return new PagedIterable<>(listByProfileAsync(resourceGroupName, profileName));
    }

    /**
     * Lists existing CDN endpoints.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list endpoints.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<EndpointInner> listByProfile(String resourceGroupName, String profileName, Context context) {
        return new PagedIterable<>(listByProfileAsync(resourceGroupName, profileName, context));
    }

    /**
     * Gets an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group
     * and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     *     group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<EndpointInner>> getWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            endpointName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Gets an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group
     * and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     *     group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<EndpointInner>> getWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                endpointName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Gets an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group
     * and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     *     group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<EndpointInner> getAsync(String resourceGroupName, String profileName, String endpointName) {
        return getWithResponseAsync(resourceGroupName, profileName, endpointName)
            .flatMap(
                (Response<EndpointInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group
     * and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     *     group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public EndpointInner get(String resourceGroupName, String profileName, String endpointName) {
        return getAsync(resourceGroupName, profileName, endpointName).block();
    }

    /**
     * Gets an existing CDN endpoint with the specified endpoint name under the specified subscription, resource group
     * and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     *     group and profile.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<EndpointInner> getWithResponse(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        return getWithResponseAsync(resourceGroupName, profileName, endpointName, context).block();
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and
     * profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (endpoint == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpoint is required and cannot be null."));
        } else {
            endpoint.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .create(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            endpointName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            endpoint,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and
     * profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (endpoint == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpoint is required and cannot be null."));
        } else {
            endpoint.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .create(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                endpointName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                endpoint,
                accept,
                context);
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and
     * profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<EndpointInner>, EndpointInner> beginCreateAsync(
        String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            createWithResponseAsync(resourceGroupName, profileName, endpointName, endpoint);
        return this
            .client
            .<EndpointInner, EndpointInner>getLroResult(
                mono, this.client.getHttpPipeline(), EndpointInner.class, EndpointInner.class, Context.NONE);
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and
     * profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<EndpointInner>, EndpointInner> beginCreateAsync(
        String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            createWithResponseAsync(resourceGroupName, profileName, endpointName, endpoint, context);
        return this
            .client
            .<EndpointInner, EndpointInner>getLroResult(
                mono, this.client.getHttpPipeline(), EndpointInner.class, EndpointInner.class, context);
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and
     * profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginCreate(
        String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return beginCreateAsync(resourceGroupName, profileName, endpointName, endpoint).getSyncPoller();
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and
     * profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginCreate(
        String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, Context context) {
        return beginCreateAsync(resourceGroupName, profileName, endpointName, endpoint, context).getSyncPoller();
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and
     * profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<EndpointInner> createAsync(
        String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return beginCreateAsync(resourceGroupName, profileName, endpointName, endpoint)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and
     * profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<EndpointInner> createAsync(
        String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, Context context) {
        return beginCreateAsync(resourceGroupName, profileName, endpointName, endpoint, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and
     * profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public EndpointInner create(
        String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint) {
        return createAsync(resourceGroupName, profileName, endpointName, endpoint).block();
    }

    /**
     * Creates a new CDN endpoint with the specified endpoint name under the specified subscription, resource group and
     * profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpoint Endpoint properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public EndpointInner create(
        String resourceGroupName, String profileName, String endpointName, EndpointInner endpoint, Context context) {
        return createAsync(resourceGroupName, profileName, endpointName, endpoint, context).block();
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin
     * operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the
     * Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String profileName,
        String endpointName,
        EndpointUpdateParameters endpointUpdateProperties) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (endpointUpdateProperties == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter endpointUpdateProperties is required and cannot be null."));
        } else {
            endpointUpdateProperties.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .update(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            endpointName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            endpointUpdateProperties,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin
     * operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the
     * Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName,
        String profileName,
        String endpointName,
        EndpointUpdateParameters endpointUpdateProperties,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (endpointUpdateProperties == null) {
            return Mono
                .error(
                    new IllegalArgumentException("Parameter endpointUpdateProperties is required and cannot be null."));
        } else {
            endpointUpdateProperties.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .update(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                endpointName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                endpointUpdateProperties,
                accept,
                context);
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin
     * operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the
     * Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<EndpointInner>, EndpointInner> beginUpdateAsync(
        String resourceGroupName,
        String profileName,
        String endpointName,
        EndpointUpdateParameters endpointUpdateProperties) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties);
        return this
            .client
            .<EndpointInner, EndpointInner>getLroResult(
                mono, this.client.getHttpPipeline(), EndpointInner.class, EndpointInner.class, Context.NONE);
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin
     * operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the
     * Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<EndpointInner>, EndpointInner> beginUpdateAsync(
        String resourceGroupName,
        String profileName,
        String endpointName,
        EndpointUpdateParameters endpointUpdateProperties,
        Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            updateWithResponseAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties, context);
        return this
            .client
            .<EndpointInner, EndpointInner>getLroResult(
                mono, this.client.getHttpPipeline(), EndpointInner.class, EndpointInner.class, context);
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin
     * operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the
     * Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginUpdate(
        String resourceGroupName,
        String profileName,
        String endpointName,
        EndpointUpdateParameters endpointUpdateProperties) {
        return beginUpdateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).getSyncPoller();
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin
     * operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the
     * Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginUpdate(
        String resourceGroupName,
        String profileName,
        String endpointName,
        EndpointUpdateParameters endpointUpdateProperties,
        Context context) {
        return beginUpdateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties, context)
            .getSyncPoller();
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin
     * operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the
     * Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<EndpointInner> updateAsync(
        String resourceGroupName,
        String profileName,
        String endpointName,
        EndpointUpdateParameters endpointUpdateProperties) {
        return beginUpdateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin
     * operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the
     * Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<EndpointInner> updateAsync(
        String resourceGroupName,
        String profileName,
        String endpointName,
        EndpointUpdateParameters endpointUpdateProperties,
        Context context) {
        return beginUpdateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin
     * operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the
     * Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public EndpointInner update(
        String resourceGroupName,
        String profileName,
        String endpointName,
        EndpointUpdateParameters endpointUpdateProperties) {
        return updateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties).block();
    }

    /**
     * Updates an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile. Only tags can be updated after creating an endpoint. To update origins, use the Update Origin
     * operation. To update origin groups, use the Update Origin group operation. To update custom domains, use the
     * Update Custom Domain operation.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param endpointUpdateProperties Endpoint update properties.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public EndpointInner update(
        String resourceGroupName,
        String profileName,
        String endpointName,
        EndpointUpdateParameters endpointUpdateProperties,
        Context context) {
        return updateAsync(resourceGroupName, profileName, endpointName, endpointUpdateProperties, context).block();
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            endpointName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                endpointName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String profileName, String endpointName) {
        Mono<Response<Flux<ByteBuffer>>> mono = deleteWithResponseAsync(resourceGroupName, profileName, endpointName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(resourceGroupName, profileName, endpointName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String profileName, String endpointName) {
        return beginDeleteAsync(resourceGroupName, profileName, endpointName).getSyncPoller();
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        return beginDeleteAsync(resourceGroupName, profileName, endpointName, context).getSyncPoller();
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName) {
        return beginDeleteAsync(resourceGroupName, profileName, endpointName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String profileName, String endpointName, Context context) {
        return beginDeleteAsync(resourceGroupName, profileName, endpointName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String endpointName) {
        deleteAsync(resourceGroupName, profileName, endpointName).block();
    }

    /**
     * Deletes an existing CDN endpoint with the specified endpoint name under the specified subscription, resource
     * group and profile.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String profileName, String endpointName, Context context) {
        deleteAsync(resourceGroupName, profileName, endpointName, context).block();
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .start(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            endpointName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> startWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .start(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                endpointName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<EndpointInner>, EndpointInner> beginStartAsync(
        String resourceGroupName, String profileName, String endpointName) {
        Mono<Response<Flux<ByteBuffer>>> mono = startWithResponseAsync(resourceGroupName, profileName, endpointName);
        return this
            .client
            .<EndpointInner, EndpointInner>getLroResult(
                mono, this.client.getHttpPipeline(), EndpointInner.class, EndpointInner.class, Context.NONE);
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<EndpointInner>, EndpointInner> beginStartAsync(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            startWithResponseAsync(resourceGroupName, profileName, endpointName, context);
        return this
            .client
            .<EndpointInner, EndpointInner>getLroResult(
                mono, this.client.getHttpPipeline(), EndpointInner.class, EndpointInner.class, context);
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginStart(
        String resourceGroupName, String profileName, String endpointName) {
        return beginStartAsync(resourceGroupName, profileName, endpointName).getSyncPoller();
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginStart(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        return beginStartAsync(resourceGroupName, profileName, endpointName, context).getSyncPoller();
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<EndpointInner> startAsync(String resourceGroupName, String profileName, String endpointName) {
        return beginStartAsync(resourceGroupName, profileName, endpointName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<EndpointInner> startAsync(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        return beginStartAsync(resourceGroupName, profileName, endpointName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public EndpointInner start(String resourceGroupName, String profileName, String endpointName) {
        return startAsync(resourceGroupName, profileName, endpointName).block();
    }

    /**
     * Starts an existing CDN endpoint that is on a stopped state.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public EndpointInner start(String resourceGroupName, String profileName, String endpointName, Context context) {
        return startAsync(resourceGroupName, profileName, endpointName, context).block();
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .stop(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            endpointName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> stopWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .stop(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                endpointName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context);
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<EndpointInner>, EndpointInner> beginStopAsync(
        String resourceGroupName, String profileName, String endpointName) {
        Mono<Response<Flux<ByteBuffer>>> mono = stopWithResponseAsync(resourceGroupName, profileName, endpointName);
        return this
            .client
            .<EndpointInner, EndpointInner>getLroResult(
                mono, this.client.getHttpPipeline(), EndpointInner.class, EndpointInner.class, Context.NONE);
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<EndpointInner>, EndpointInner> beginStopAsync(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            stopWithResponseAsync(resourceGroupName, profileName, endpointName, context);
        return this
            .client
            .<EndpointInner, EndpointInner>getLroResult(
                mono, this.client.getHttpPipeline(), EndpointInner.class, EndpointInner.class, context);
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginStop(
        String resourceGroupName, String profileName, String endpointName) {
        return beginStopAsync(resourceGroupName, profileName, endpointName).getSyncPoller();
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<EndpointInner>, EndpointInner> beginStop(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        return beginStopAsync(resourceGroupName, profileName, endpointName, context).getSyncPoller();
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<EndpointInner> stopAsync(String resourceGroupName, String profileName, String endpointName) {
        return beginStopAsync(resourceGroupName, profileName, endpointName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<EndpointInner> stopAsync(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        return beginStopAsync(resourceGroupName, profileName, endpointName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public EndpointInner stop(String resourceGroupName, String profileName, String endpointName) {
        return stopAsync(resourceGroupName, profileName, endpointName).block();
    }

    /**
     * Stops an existing running CDN endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return cDN endpoint is the entity within a CDN profile containing configuration information such as origin,
     *     protocol, content caching and delivery behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public EndpointInner stop(String resourceGroupName, String profileName, String endpointName, Context context) {
        return stopAsync(resourceGroupName, profileName, endpointName, context).block();
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> purgeContentWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (contentPaths == null) {
            return Mono.error(new IllegalArgumentException("Parameter contentPaths is required and cannot be null."));
        }
        final String accept = "application/json";
        PurgeParameters contentFilePaths = new PurgeParameters();
        contentFilePaths.withContentPaths(contentPaths);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .purgeContent(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            endpointName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            contentFilePaths,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> purgeContentWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (contentPaths == null) {
            return Mono.error(new IllegalArgumentException("Parameter contentPaths is required and cannot be null."));
        }
        final String accept = "application/json";
        PurgeParameters contentFilePaths = new PurgeParameters();
        contentFilePaths.withContentPaths(contentPaths);
        context = this.client.mergeContext(context);
        return service
            .purgeContent(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                endpointName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                contentFilePaths,
                accept,
                context);
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginPurgeContentAsync(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            purgeContentWithResponseAsync(resourceGroupName, profileName, endpointName, contentPaths);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginPurgeContentAsync(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            purgeContentWithResponseAsync(resourceGroupName, profileName, endpointName, contentPaths, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginPurgeContent(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return beginPurgeContentAsync(resourceGroupName, profileName, endpointName, contentPaths).getSyncPoller();
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginPurgeContent(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        return beginPurgeContentAsync(resourceGroupName, profileName, endpointName, contentPaths, context)
            .getSyncPoller();
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> purgeContentAsync(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return beginPurgeContentAsync(resourceGroupName, profileName, endpointName, contentPaths)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> purgeContentAsync(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        return beginPurgeContentAsync(resourceGroupName, profileName, endpointName, contentPaths, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void purgeContent(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        purgeContentAsync(resourceGroupName, profileName, endpointName, contentPaths).block();
    }

    /**
     * Removes a content from CDN.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be purged. Can describe a file path or a wild card directory.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void purgeContent(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        purgeContentAsync(resourceGroupName, profileName, endpointName, contentPaths, context).block();
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> loadContentWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (contentPaths == null) {
            return Mono.error(new IllegalArgumentException("Parameter contentPaths is required and cannot be null."));
        }
        final String accept = "application/json";
        LoadParameters contentFilePaths = new LoadParameters();
        contentFilePaths.withContentPaths(contentPaths);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .loadContent(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            endpointName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            contentFilePaths,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> loadContentWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (contentPaths == null) {
            return Mono.error(new IllegalArgumentException("Parameter contentPaths is required and cannot be null."));
        }
        final String accept = "application/json";
        LoadParameters contentFilePaths = new LoadParameters();
        contentFilePaths.withContentPaths(contentPaths);
        context = this.client.mergeContext(context);
        return service
            .loadContent(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                endpointName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                contentFilePaths,
                accept,
                context);
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginLoadContentAsync(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            loadContentWithResponseAsync(resourceGroupName, profileName, endpointName, contentPaths);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginLoadContentAsync(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            loadContentWithResponseAsync(resourceGroupName, profileName, endpointName, contentPaths, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginLoadContent(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return beginLoadContentAsync(resourceGroupName, profileName, endpointName, contentPaths).getSyncPoller();
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginLoadContent(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        return beginLoadContentAsync(resourceGroupName, profileName, endpointName, contentPaths, context)
            .getSyncPoller();
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> loadContentAsync(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        return beginLoadContentAsync(resourceGroupName, profileName, endpointName, contentPaths)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> loadContentAsync(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        return beginLoadContentAsync(resourceGroupName, profileName, endpointName, contentPaths, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void loadContent(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths) {
        loadContentAsync(resourceGroupName, profileName, endpointName, contentPaths).block();
    }

    /**
     * Pre-loads a content to CDN. Available for Verizon Profiles.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param contentPaths The path to the content to be loaded. Path should be a relative file URL of the origin.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void loadContent(
        String resourceGroupName, String profileName, String endpointName, List<String> contentPaths, Context context) {
        loadContentAsync(resourceGroupName, profileName, endpointName, contentPaths, context).block();
    }

    /**
     * Validates the custom domain mapping to ensure it maps to the correct CDN endpoint in DNS.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param hostname The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of custom domain validation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ValidateCustomDomainOutputInner>> validateCustomDomainWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, String hostname) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (hostname == null) {
            return Mono.error(new IllegalArgumentException("Parameter hostname is required and cannot be null."));
        }
        final String accept = "application/json";
        ValidateCustomDomainInput customDomainProperties = new ValidateCustomDomainInput();
        customDomainProperties.withHostname(hostname);
        return FluxUtil
            .withContext(
                context ->
                    service
                        .validateCustomDomain(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            endpointName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            customDomainProperties,
                            accept,
                            context))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Validates the custom domain mapping to ensure it maps to the correct CDN endpoint in DNS.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param hostname The host name of the custom domain. Must be a domain name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of custom domain validation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ValidateCustomDomainOutputInner>> validateCustomDomainWithResponseAsync(
        String resourceGroupName, String profileName, String endpointName, String hostname, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (hostname == null) {
            return Mono.error(new IllegalArgumentException("Parameter hostname is required and cannot be null."));
        }
        final String accept = "application/json";
        ValidateCustomDomainInput customDomainProperties = new ValidateCustomDomainInput();
        customDomainProperties.withHostname(hostname);
        context = this.client.mergeContext(context);
        return service
            .validateCustomDomain(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                endpointName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                customDomainProperties,
                accept,
                context);
    }

    /**
     * Validates the custom domain mapping to ensure it maps to the correct CDN endpoint in DNS.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param hostname The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of custom domain validation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ValidateCustomDomainOutputInner> validateCustomDomainAsync(
        String resourceGroupName, String profileName, String endpointName, String hostname) {
        return validateCustomDomainWithResponseAsync(resourceGroupName, profileName, endpointName, hostname)
            .flatMap(
                (Response<ValidateCustomDomainOutputInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Validates the custom domain mapping to ensure it maps to the correct CDN endpoint in DNS.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param hostname The host name of the custom domain. Must be a domain name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of custom domain validation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ValidateCustomDomainOutputInner validateCustomDomain(
        String resourceGroupName, String profileName, String endpointName, String hostname) {
        return validateCustomDomainAsync(resourceGroupName, profileName, endpointName, hostname).block();
    }

    /**
     * Validates the custom domain mapping to ensure it maps to the correct CDN endpoint in DNS.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param hostname The host name of the custom domain. Must be a domain name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of custom domain validation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ValidateCustomDomainOutputInner> validateCustomDomainWithResponse(
        String resourceGroupName, String profileName, String endpointName, String hostname, Context context) {
        return validateCustomDomainWithResponseAsync(resourceGroupName, profileName, endpointName, hostname, context)
            .block();
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check resource usage API.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceUsageInner>> listResourceUsageSinglePageAsync(
        String resourceGroupName, String profileName, String endpointName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listResourceUsage(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            profileName,
                            endpointName,
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            accept,
                            context))
            .<PagedResponse<ResourceUsageInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check resource usage API.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceUsageInner>> listResourceUsageSinglePageAsync(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (profileName == null) {
            return Mono.error(new IllegalArgumentException("Parameter profileName is required and cannot be null."));
        }
        if (endpointName == null) {
            return Mono.error(new IllegalArgumentException("Parameter endpointName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listResourceUsage(
                this.client.getEndpoint(),
                resourceGroupName,
                profileName,
                endpointName,
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check resource usage API.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<ResourceUsageInner> listResourceUsageAsync(
        String resourceGroupName, String profileName, String endpointName) {
        return new PagedFlux<>(
            () -> listResourceUsageSinglePageAsync(resourceGroupName, profileName, endpointName),
            nextLink -> listResourceUsageNextSinglePageAsync(nextLink));
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check resource usage API.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<ResourceUsageInner> listResourceUsageAsync(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        return new PagedFlux<>(
            () -> listResourceUsageSinglePageAsync(resourceGroupName, profileName, endpointName, context),
            nextLink -> listResourceUsageNextSinglePageAsync(nextLink, context));
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check resource usage API.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ResourceUsageInner> listResourceUsage(
        String resourceGroupName, String profileName, String endpointName) {
        return new PagedIterable<>(listResourceUsageAsync(resourceGroupName, profileName, endpointName));
    }

    /**
     * Checks the quota and usage of geo filters and custom domains under the given endpoint.
     *
     * @param resourceGroupName Name of the Resource group within the Azure subscription.
     * @param profileName Name of the CDN profile which is unique within the resource group.
     * @param endpointName Name of the endpoint under the profile which is unique globally.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check resource usage API.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<ResourceUsageInner> listResourceUsage(
        String resourceGroupName, String profileName, String endpointName, Context context) {
        return new PagedIterable<>(listResourceUsageAsync(resourceGroupName, profileName, endpointName, context));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list endpoints.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<EndpointInner>> listByProfileNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByProfileNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<EndpointInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list endpoints.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<EndpointInner>> listByProfileNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByProfileNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check resource usage API.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceUsageInner>> listResourceUsageNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listResourceUsageNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<ResourceUsageInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .subscriberContext(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext())));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return output of check resource usage API.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<ResourceUsageInner>> listResourceUsageNextSinglePageAsync(
        String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listResourceUsageNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
