/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.implementation.AvailabilitySetsImpl;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientBuilder;
import com.azure.resourcemanager.compute.implementation.ComputeSkusImpl;
import com.azure.resourcemanager.compute.implementation.ComputeUsagesImpl;
import com.azure.resourcemanager.compute.implementation.DisksImpl;
import com.azure.resourcemanager.compute.implementation.GalleriesImpl;
import com.azure.resourcemanager.compute.implementation.GalleryImageVersionsImpl;
import com.azure.resourcemanager.compute.implementation.GalleryImagesImpl;
import com.azure.resourcemanager.compute.implementation.SnapshotsImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineCustomImagesImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineExtensionImagesImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineImagesImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachinePublishersImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineScaleSetsImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachinesImpl;
import com.azure.resourcemanager.compute.models.AvailabilitySets;
import com.azure.resourcemanager.compute.models.ComputeSkus;
import com.azure.resourcemanager.compute.models.ComputeUsages;
import com.azure.resourcemanager.compute.models.Disks;
import com.azure.resourcemanager.compute.models.Galleries;
import com.azure.resourcemanager.compute.models.GalleryImageVersions;
import com.azure.resourcemanager.compute.models.GalleryImages;
import com.azure.resourcemanager.compute.models.Snapshots;
import com.azure.resourcemanager.compute.models.VirtualMachineCustomImages;
import com.azure.resourcemanager.compute.models.VirtualMachineExtensionImages;
import com.azure.resourcemanager.compute.models.VirtualMachineImages;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSets;
import com.azure.resourcemanager.compute.models.VirtualMachines;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.resources.fluentcore.arm.AzureConfigurable;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.HttpPipelineProvider;
import com.azure.resourcemanager.storage.StorageManager;

public final class ComputeManager
extends Manager<ComputeManagementClient> {
    private final StorageManager storageManager;
    private final NetworkManager networkManager;
    private final AuthorizationManager authorizationManager;
    private AvailabilitySets availabilitySets;
    private VirtualMachines virtualMachines;
    private VirtualMachineImages virtualMachineImages;
    private VirtualMachineExtensionImages virtualMachineExtensionImages;
    private VirtualMachineScaleSets virtualMachineScaleSets;
    private ComputeUsages computeUsages;
    private VirtualMachineCustomImages virtualMachineCustomImages;
    private Disks disks;
    private Snapshots snapshots;
    private ComputeSkus computeSkus;
    private Galleries galleries;
    private GalleryImages galleryImages;
    private GalleryImageVersions galleryImageVersions;

    public StorageManager storageManager() {
        return this.storageManager;
    }

    public NetworkManager networkManager() {
        return this.networkManager;
    }

    public AuthorizationManager authorizationManager() {
        return this.authorizationManager;
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static ComputeManager authenticate(TokenCredential credential, AzureProfile profile) {
        return ComputeManager.authenticate(HttpPipelineProvider.buildHttpPipeline((TokenCredential)credential, (AzureProfile)profile), profile);
    }

    private static ComputeManager authenticate(HttpPipeline httpPipeline, AzureProfile profile) {
        return new ComputeManager(httpPipeline, profile);
    }

    private ComputeManager(HttpPipeline httpPipeline, AzureProfile profile) {
        super(httpPipeline, profile, (Object)new ComputeManagementClientBuilder().pipeline(httpPipeline).subscriptionId(profile.getSubscriptionId()).buildClient());
        this.storageManager = ((StorageManager.Configurable)AzureConfigurableImpl.configureHttpPipeline((HttpPipeline)httpPipeline, (AzureConfigurable)StorageManager.configure())).authenticate(null, profile);
        this.networkManager = ((NetworkManager.Configurable)AzureConfigurableImpl.configureHttpPipeline((HttpPipeline)httpPipeline, (AzureConfigurable)NetworkManager.configure())).authenticate(null, profile);
        this.authorizationManager = ((AuthorizationManager.Configurable)AzureConfigurableImpl.configureHttpPipeline((HttpPipeline)httpPipeline, (AzureConfigurable)AuthorizationManager.configure())).authenticate(null, profile);
    }

    public AvailabilitySets availabilitySets() {
        if (this.availabilitySets == null) {
            this.availabilitySets = new AvailabilitySetsImpl(this);
        }
        return this.availabilitySets;
    }

    public VirtualMachines virtualMachines() {
        if (this.virtualMachines == null) {
            this.virtualMachines = new VirtualMachinesImpl(this, this.storageManager, this.networkManager, this.authorizationManager);
        }
        return this.virtualMachines;
    }

    public VirtualMachineImages virtualMachineImages() {
        if (this.virtualMachineImages == null) {
            this.virtualMachineImages = new VirtualMachineImagesImpl(new VirtualMachinePublishersImpl(((ComputeManagementClient)this.serviceClient()).getVirtualMachineImages(), ((ComputeManagementClient)this.serviceClient()).getVirtualMachineExtensionImages()), ((ComputeManagementClient)this.serviceClient()).getVirtualMachineImages());
        }
        return this.virtualMachineImages;
    }

    public VirtualMachineExtensionImages virtualMachineExtensionImages() {
        if (this.virtualMachineExtensionImages == null) {
            this.virtualMachineExtensionImages = new VirtualMachineExtensionImagesImpl(new VirtualMachinePublishersImpl(((ComputeManagementClient)this.serviceClient()).getVirtualMachineImages(), ((ComputeManagementClient)this.serviceClient()).getVirtualMachineExtensionImages()));
        }
        return this.virtualMachineExtensionImages;
    }

    public VirtualMachineScaleSets virtualMachineScaleSets() {
        if (this.virtualMachineScaleSets == null) {
            this.virtualMachineScaleSets = new VirtualMachineScaleSetsImpl(this, this.storageManager, this.networkManager, this.authorizationManager);
        }
        return this.virtualMachineScaleSets;
    }

    public ComputeUsages usages() {
        if (this.computeUsages == null) {
            this.computeUsages = new ComputeUsagesImpl((ComputeManagementClient)this.serviceClient());
        }
        return this.computeUsages;
    }

    public VirtualMachineCustomImages virtualMachineCustomImages() {
        if (this.virtualMachineCustomImages == null) {
            this.virtualMachineCustomImages = new VirtualMachineCustomImagesImpl(this);
        }
        return this.virtualMachineCustomImages;
    }

    public Disks disks() {
        if (this.disks == null) {
            this.disks = new DisksImpl(this);
        }
        return this.disks;
    }

    public Snapshots snapshots() {
        if (this.snapshots == null) {
            this.snapshots = new SnapshotsImpl(this);
        }
        return this.snapshots;
    }

    public ComputeSkus computeSkus() {
        if (this.computeSkus == null) {
            this.computeSkus = new ComputeSkusImpl(this);
        }
        return this.computeSkus;
    }

    public Galleries galleries() {
        if (this.galleries == null) {
            this.galleries = new GalleriesImpl(this);
        }
        return this.galleries;
    }

    public GalleryImages galleryImages() {
        if (this.galleryImages == null) {
            this.galleryImages = new GalleryImagesImpl(this);
        }
        return this.galleryImages;
    }

    public GalleryImageVersions galleryImageVersions() {
        if (this.galleryImageVersions == null) {
            this.galleryImageVersions = new GalleryImageVersionsImpl(this);
        }
        return this.galleryImageVersions;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public ComputeManager authenticate(TokenCredential credential, AzureProfile profile) {
            return ComputeManager.authenticate(this.buildHttpPipeline(credential, profile), profile);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public ComputeManager authenticate(TokenCredential var1, AzureProfile var2);
    }
}

