/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.SecurityTypes;
import com.azure.resourcemanager.compute.models.UefiSettings;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class SecurityProfile {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SecurityProfile.class);
    @JsonProperty(value="uefiSettings")
    private UefiSettings uefiSettings;
    @JsonProperty(value="encryptionAtHost")
    private Boolean encryptionAtHost;
    @JsonProperty(value="securityType")
    private SecurityTypes securityType;

    public UefiSettings uefiSettings() {
        return this.uefiSettings;
    }

    public SecurityProfile withUefiSettings(UefiSettings uefiSettings) {
        this.uefiSettings = uefiSettings;
        return this;
    }

    public Boolean encryptionAtHost() {
        return this.encryptionAtHost;
    }

    public SecurityProfile withEncryptionAtHost(Boolean encryptionAtHost) {
        this.encryptionAtHost = encryptionAtHost;
        return this;
    }

    public SecurityTypes securityType() {
        return this.securityType;
    }

    public SecurityProfile withSecurityType(SecurityTypes securityType) {
        this.securityType = securityType;
        return this;
    }

    public void validate() {
        if (this.uefiSettings() != null) {
            this.uefiSettings().validate();
        }
    }
}

