/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.ExecutionState;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class VirtualMachineRunCommandInstanceView {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineRunCommandInstanceView.class);
    @JsonProperty(value="executionState")
    private ExecutionState executionState;
    @JsonProperty(value="executionMessage")
    private String executionMessage;
    @JsonProperty(value="exitCode")
    private Integer exitCode;
    @JsonProperty(value="output")
    private String output;
    @JsonProperty(value="error")
    private String error;
    @JsonProperty(value="startTime")
    private OffsetDateTime startTime;
    @JsonProperty(value="endTime")
    private OffsetDateTime endTime;
    @JsonProperty(value="statuses")
    private List<InstanceViewStatus> statuses;

    public ExecutionState executionState() {
        return this.executionState;
    }

    public VirtualMachineRunCommandInstanceView withExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
        return this;
    }

    public String executionMessage() {
        return this.executionMessage;
    }

    public VirtualMachineRunCommandInstanceView withExecutionMessage(String executionMessage) {
        this.executionMessage = executionMessage;
        return this;
    }

    public Integer exitCode() {
        return this.exitCode;
    }

    public VirtualMachineRunCommandInstanceView withExitCode(Integer exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    public String output() {
        return this.output;
    }

    public VirtualMachineRunCommandInstanceView withOutput(String output) {
        this.output = output;
        return this;
    }

    public String error() {
        return this.error;
    }

    public VirtualMachineRunCommandInstanceView withError(String error) {
        this.error = error;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public VirtualMachineRunCommandInstanceView withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public VirtualMachineRunCommandInstanceView withEndTime(OffsetDateTime endTime) {
        this.endTime = endTime;
        return this;
    }

    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    public VirtualMachineRunCommandInstanceView withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    public void validate() {
        if (this.statuses() != null) {
            this.statuses().forEach(e -> e.validate());
        }
    }
}

