/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.AutomaticRepairsPolicy;
import com.azure.resourcemanager.compute.models.OrchestrationMode;
import com.azure.resourcemanager.compute.models.ScaleInPolicy;
import com.azure.resourcemanager.compute.models.SpotRestorePolicy;
import com.azure.resourcemanager.compute.models.UpgradePolicy;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class VirtualMachineScaleSetProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineScaleSetProperties.class);
    @JsonProperty(value="upgradePolicy")
    private UpgradePolicy upgradePolicy;
    @JsonProperty(value="automaticRepairsPolicy")
    private AutomaticRepairsPolicy automaticRepairsPolicy;
    @JsonProperty(value="virtualMachineProfile")
    private VirtualMachineScaleSetVMProfile virtualMachineProfile;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="overprovision")
    private Boolean overprovision;
    @JsonProperty(value="doNotRunExtensionsOnOverprovisionedVMs")
    private Boolean doNotRunExtensionsOnOverprovisionedVMs;
    @JsonProperty(value="uniqueId", access=JsonProperty.Access.WRITE_ONLY)
    private String uniqueId;
    @JsonProperty(value="singlePlacementGroup")
    private Boolean singlePlacementGroup;
    @JsonProperty(value="zoneBalance")
    private Boolean zoneBalance;
    @JsonProperty(value="platformFaultDomainCount")
    private Integer platformFaultDomainCount;
    @JsonProperty(value="proximityPlacementGroup")
    private SubResource proximityPlacementGroup;
    @JsonProperty(value="hostGroup")
    private SubResource hostGroup;
    @JsonProperty(value="additionalCapabilities")
    private AdditionalCapabilities additionalCapabilities;
    @JsonProperty(value="scaleInPolicy")
    private ScaleInPolicy scaleInPolicy;
    @JsonProperty(value="orchestrationMode")
    private OrchestrationMode orchestrationMode;
    @JsonProperty(value="spotRestorePolicy")
    private SpotRestorePolicy spotRestorePolicy;
    @JsonProperty(value="timeCreated", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeCreated;

    public UpgradePolicy upgradePolicy() {
        return this.upgradePolicy;
    }

    public VirtualMachineScaleSetProperties withUpgradePolicy(UpgradePolicy upgradePolicy) {
        this.upgradePolicy = upgradePolicy;
        return this;
    }

    public AutomaticRepairsPolicy automaticRepairsPolicy() {
        return this.automaticRepairsPolicy;
    }

    public VirtualMachineScaleSetProperties withAutomaticRepairsPolicy(AutomaticRepairsPolicy automaticRepairsPolicy) {
        this.automaticRepairsPolicy = automaticRepairsPolicy;
        return this;
    }

    public VirtualMachineScaleSetVMProfile virtualMachineProfile() {
        return this.virtualMachineProfile;
    }

    public VirtualMachineScaleSetProperties withVirtualMachineProfile(VirtualMachineScaleSetVMProfile virtualMachineProfile) {
        this.virtualMachineProfile = virtualMachineProfile;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Boolean overprovision() {
        return this.overprovision;
    }

    public VirtualMachineScaleSetProperties withOverprovision(Boolean overprovision) {
        this.overprovision = overprovision;
        return this;
    }

    public Boolean doNotRunExtensionsOnOverprovisionedVMs() {
        return this.doNotRunExtensionsOnOverprovisionedVMs;
    }

    public VirtualMachineScaleSetProperties withDoNotRunExtensionsOnOverprovisionedVMs(Boolean doNotRunExtensionsOnOverprovisionedVMs) {
        this.doNotRunExtensionsOnOverprovisionedVMs = doNotRunExtensionsOnOverprovisionedVMs;
        return this;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public Boolean singlePlacementGroup() {
        return this.singlePlacementGroup;
    }

    public VirtualMachineScaleSetProperties withSinglePlacementGroup(Boolean singlePlacementGroup) {
        this.singlePlacementGroup = singlePlacementGroup;
        return this;
    }

    public Boolean zoneBalance() {
        return this.zoneBalance;
    }

    public VirtualMachineScaleSetProperties withZoneBalance(Boolean zoneBalance) {
        this.zoneBalance = zoneBalance;
        return this;
    }

    public Integer platformFaultDomainCount() {
        return this.platformFaultDomainCount;
    }

    public VirtualMachineScaleSetProperties withPlatformFaultDomainCount(Integer platformFaultDomainCount) {
        this.platformFaultDomainCount = platformFaultDomainCount;
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.proximityPlacementGroup;
    }

    public VirtualMachineScaleSetProperties withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        this.proximityPlacementGroup = proximityPlacementGroup;
        return this;
    }

    public SubResource hostGroup() {
        return this.hostGroup;
    }

    public VirtualMachineScaleSetProperties withHostGroup(SubResource hostGroup) {
        this.hostGroup = hostGroup;
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.additionalCapabilities;
    }

    public VirtualMachineScaleSetProperties withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        this.additionalCapabilities = additionalCapabilities;
        return this;
    }

    public ScaleInPolicy scaleInPolicy() {
        return this.scaleInPolicy;
    }

    public VirtualMachineScaleSetProperties withScaleInPolicy(ScaleInPolicy scaleInPolicy) {
        this.scaleInPolicy = scaleInPolicy;
        return this;
    }

    public OrchestrationMode orchestrationMode() {
        return this.orchestrationMode;
    }

    public VirtualMachineScaleSetProperties withOrchestrationMode(OrchestrationMode orchestrationMode) {
        this.orchestrationMode = orchestrationMode;
        return this;
    }

    public SpotRestorePolicy spotRestorePolicy() {
        return this.spotRestorePolicy;
    }

    public VirtualMachineScaleSetProperties withSpotRestorePolicy(SpotRestorePolicy spotRestorePolicy) {
        this.spotRestorePolicy = spotRestorePolicy;
        return this;
    }

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public void validate() {
        if (this.upgradePolicy() != null) {
            this.upgradePolicy().validate();
        }
        if (this.automaticRepairsPolicy() != null) {
            this.automaticRepairsPolicy().validate();
        }
        if (this.virtualMachineProfile() != null) {
            this.virtualMachineProfile().validate();
        }
        if (this.additionalCapabilities() != null) {
            this.additionalCapabilities().validate();
        }
        if (this.scaleInPolicy() != null) {
            this.scaleInPolicy().validate();
        }
        if (this.spotRestorePolicy() != null) {
            this.spotRestorePolicy().validate();
        }
    }
}

