/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.HardwareProfile;
import com.azure.resourcemanager.compute.models.OSProfile;
import com.azure.resourcemanager.compute.models.RestorePointSourceVMStorageProfile;
import com.azure.resourcemanager.compute.models.SecurityProfile;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class RestorePointSourceMetadata {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RestorePointSourceMetadata.class);
    @JsonProperty(value="hardwareProfile")
    private HardwareProfile hardwareProfile;
    @JsonProperty(value="storageProfile")
    private RestorePointSourceVMStorageProfile storageProfile;
    @JsonProperty(value="osProfile")
    private OSProfile osProfile;
    @JsonProperty(value="diagnosticsProfile")
    private DiagnosticsProfile diagnosticsProfile;
    @JsonProperty(value="licenseType")
    private String licenseType;
    @JsonProperty(value="vmId")
    private String vmId;
    @JsonProperty(value="securityProfile")
    private SecurityProfile securityProfile;
    @JsonProperty(value="location")
    private String location;

    public HardwareProfile hardwareProfile() {
        return this.hardwareProfile;
    }

    public RestorePointSourceMetadata withHardwareProfile(HardwareProfile hardwareProfile) {
        this.hardwareProfile = hardwareProfile;
        return this;
    }

    public RestorePointSourceVMStorageProfile storageProfile() {
        return this.storageProfile;
    }

    public RestorePointSourceMetadata withStorageProfile(RestorePointSourceVMStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public OSProfile osProfile() {
        return this.osProfile;
    }

    public RestorePointSourceMetadata withOsProfile(OSProfile osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public DiagnosticsProfile diagnosticsProfile() {
        return this.diagnosticsProfile;
    }

    public RestorePointSourceMetadata withDiagnosticsProfile(DiagnosticsProfile diagnosticsProfile) {
        this.diagnosticsProfile = diagnosticsProfile;
        return this;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public RestorePointSourceMetadata withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public String vmId() {
        return this.vmId;
    }

    public RestorePointSourceMetadata withVmId(String vmId) {
        this.vmId = vmId;
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public RestorePointSourceMetadata withSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public String location() {
        return this.location;
    }

    public RestorePointSourceMetadata withLocation(String location) {
        this.location = location;
        return this;
    }

    public void validate() {
        if (this.hardwareProfile() != null) {
            this.hardwareProfile().validate();
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
        if (this.diagnosticsProfile() != null) {
            this.diagnosticsProfile().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }
}

