/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.resourcemanager.compute.models.ApiError;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetType;
import com.azure.resourcemanager.compute.models.KeyForDiskEncryptionSet;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class EncryptionSetProperties {
    @JsonProperty(value="encryptionType")
    private DiskEncryptionSetType encryptionType;
    @JsonProperty(value="activeKey")
    private KeyForDiskEncryptionSet activeKey;
    @JsonProperty(value="previousKeys", access=JsonProperty.Access.WRITE_ONLY)
    private List<KeyForDiskEncryptionSet> previousKeys;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="rotationToLatestKeyVersionEnabled")
    private Boolean rotationToLatestKeyVersionEnabled;
    @JsonProperty(value="lastKeyRotationTimestamp", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime lastKeyRotationTimestamp;
    @JsonProperty(value="autoKeyRotationError", access=JsonProperty.Access.WRITE_ONLY)
    private ApiError autoKeyRotationError;

    public DiskEncryptionSetType encryptionType() {
        return this.encryptionType;
    }

    public EncryptionSetProperties withEncryptionType(DiskEncryptionSetType encryptionType) {
        this.encryptionType = encryptionType;
        return this;
    }

    public KeyForDiskEncryptionSet activeKey() {
        return this.activeKey;
    }

    public EncryptionSetProperties withActiveKey(KeyForDiskEncryptionSet activeKey) {
        this.activeKey = activeKey;
        return this;
    }

    public List<KeyForDiskEncryptionSet> previousKeys() {
        return this.previousKeys;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Boolean rotationToLatestKeyVersionEnabled() {
        return this.rotationToLatestKeyVersionEnabled;
    }

    public EncryptionSetProperties withRotationToLatestKeyVersionEnabled(Boolean rotationToLatestKeyVersionEnabled) {
        this.rotationToLatestKeyVersionEnabled = rotationToLatestKeyVersionEnabled;
        return this;
    }

    public OffsetDateTime lastKeyRotationTimestamp() {
        return this.lastKeyRotationTimestamp;
    }

    public ApiError autoKeyRotationError() {
        return this.autoKeyRotationError;
    }

    public void validate() {
        if (this.activeKey() != null) {
            this.activeKey().validate();
        }
        if (this.previousKeys() != null) {
            this.previousKeys().forEach(e -> e.validate());
        }
        if (this.autoKeyRotationError() != null) {
            this.autoKeyRotationError().validate();
        }
    }
}

