/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.CommunityGalleryImagesClient;
import com.azure.resourcemanager.compute.fluent.models.CommunityGalleryImageInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import reactor.core.publisher.Mono;

public final class CommunityGalleryImagesClientImpl
implements CommunityGalleryImagesClient {
    private final CommunityGalleryImagesService service;
    private final ComputeManagementClientImpl client;

    CommunityGalleryImagesClientImpl(ComputeManagementClientImpl client) {
        this.service = (CommunityGalleryImagesService)RestProxy.create(CommunityGalleryImagesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CommunityGalleryImageInner>> getWithResponseAsync(String location, String publicGalleryName, String galleryImageName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publicGalleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicGalleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), location, "2021-07-01", publicGalleryName, galleryImageName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CommunityGalleryImageInner>> getWithResponseAsync(String location, String publicGalleryName, String galleryImageName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (publicGalleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter publicGalleryName is required and cannot be null."));
        }
        if (galleryImageName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryImageName is required and cannot be null."));
        }
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), location, "2021-07-01", publicGalleryName, galleryImageName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CommunityGalleryImageInner> getAsync(String location, String publicGalleryName, String galleryImageName) {
        return this.getWithResponseAsync(location, publicGalleryName, galleryImageName).flatMap(res -> Mono.justOrEmpty((Object)((CommunityGalleryImageInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CommunityGalleryImageInner get(String location, String publicGalleryName, String galleryImageName) {
        return (CommunityGalleryImageInner)this.getAsync(location, publicGalleryName, galleryImageName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CommunityGalleryImageInner> getWithResponse(String location, String publicGalleryName, String galleryImageName, Context context) {
        return (Response)this.getWithResponseAsync(location, publicGalleryName, galleryImageName, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    private static interface CommunityGalleryImagesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/communityGalleries/{publicGalleryName}/images/{galleryImageName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<CommunityGalleryImageInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="location") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="publicGalleryName") String var5, @PathParam(value="galleryImageName") String var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

