/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.compute.fluent.models.EncryptionSetProperties;
import com.azure.resourcemanager.compute.models.ApiError;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetType;
import com.azure.resourcemanager.compute.models.EncryptionSetIdentity;
import com.azure.resourcemanager.compute.models.KeyForDiskEncryptionSet;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class DiskEncryptionSetInner
extends Resource {
    @JsonProperty(value="identity")
    private EncryptionSetIdentity identity;
    @JsonProperty(value="properties")
    private EncryptionSetProperties innerProperties;

    public EncryptionSetIdentity identity() {
        return this.identity;
    }

    public DiskEncryptionSetInner withIdentity(EncryptionSetIdentity identity) {
        this.identity = identity;
        return this;
    }

    private EncryptionSetProperties innerProperties() {
        return this.innerProperties;
    }

    public DiskEncryptionSetInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DiskEncryptionSetInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public DiskEncryptionSetType encryptionType() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionType();
    }

    public DiskEncryptionSetInner withEncryptionType(DiskEncryptionSetType encryptionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EncryptionSetProperties();
        }
        this.innerProperties().withEncryptionType(encryptionType);
        return this;
    }

    public KeyForDiskEncryptionSet activeKey() {
        return this.innerProperties() == null ? null : this.innerProperties().activeKey();
    }

    public DiskEncryptionSetInner withActiveKey(KeyForDiskEncryptionSet activeKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EncryptionSetProperties();
        }
        this.innerProperties().withActiveKey(activeKey);
        return this;
    }

    public List<KeyForDiskEncryptionSet> previousKeys() {
        return this.innerProperties() == null ? null : this.innerProperties().previousKeys();
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Boolean rotationToLatestKeyVersionEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().rotationToLatestKeyVersionEnabled();
    }

    public DiskEncryptionSetInner withRotationToLatestKeyVersionEnabled(Boolean rotationToLatestKeyVersionEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EncryptionSetProperties();
        }
        this.innerProperties().withRotationToLatestKeyVersionEnabled(rotationToLatestKeyVersionEnabled);
        return this;
    }

    public OffsetDateTime lastKeyRotationTimestamp() {
        return this.innerProperties() == null ? null : this.innerProperties().lastKeyRotationTimestamp();
    }

    public ApiError autoKeyRotationError() {
        return this.innerProperties() == null ? null : this.innerProperties().autoKeyRotationError();
    }

    public String federatedClientId() {
        return this.innerProperties() == null ? null : this.innerProperties().federatedClientId();
    }

    public DiskEncryptionSetInner withFederatedClientId(String federatedClientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new EncryptionSetProperties();
        }
        this.innerProperties().withFederatedClientId(federatedClientId);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

