/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.CloudServiceOperatingSystemsClient;
import com.azure.resourcemanager.compute.fluent.models.OSFamilyInner;
import com.azure.resourcemanager.compute.fluent.models.OSVersionInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.OSFamilyListResult;
import com.azure.resourcemanager.compute.models.OSVersionListResult;
import reactor.core.publisher.Mono;

public final class CloudServiceOperatingSystemsClientImpl
implements CloudServiceOperatingSystemsClient {
    private final CloudServiceOperatingSystemsService service;
    private final ComputeManagementClientImpl client;

    CloudServiceOperatingSystemsClientImpl(ComputeManagementClientImpl client) {
        this.service = (CloudServiceOperatingSystemsService)RestProxy.create(CloudServiceOperatingSystemsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OSVersionInner>> getOSVersionWithResponseAsync(String location, String osVersionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (osVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter osVersionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-04-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOSVersion(this.client.getEndpoint(), location, osVersionName, this.client.getSubscriptionId(), "2022-04-04", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<OSVersionInner>> getOSVersionWithResponseAsync(String location, String osVersionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (osVersionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter osVersionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-04-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getOSVersion(this.client.getEndpoint(), location, osVersionName, this.client.getSubscriptionId(), "2022-04-04", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OSVersionInner> getOSVersionAsync(String location, String osVersionName) {
        return this.getOSVersionWithResponseAsync(location, osVersionName).flatMap(res -> Mono.justOrEmpty((Object)((OSVersionInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OSVersionInner getOSVersion(String location, String osVersionName) {
        return (OSVersionInner)this.getOSVersionAsync(location, osVersionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OSVersionInner> getOSVersionWithResponse(String location, String osVersionName, Context context) {
        return (Response)this.getOSVersionWithResponseAsync(location, osVersionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OSVersionInner>> listOSVersionsSinglePageAsync(String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-04-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOSVersions(this.client.getEndpoint(), location, this.client.getSubscriptionId(), "2022-04-04", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OSVersionListResult)res.getValue()).value(), ((OSVersionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OSVersionInner>> listOSVersionsSinglePageAsync(String location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-04-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listOSVersions(this.client.getEndpoint(), location, this.client.getSubscriptionId(), "2022-04-04", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OSVersionListResult)res.getValue()).value(), ((OSVersionListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OSVersionInner> listOSVersionsAsync(String location) {
        return new PagedFlux(() -> this.listOSVersionsSinglePageAsync(location), nextLink -> this.listOSVersionsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<OSVersionInner> listOSVersionsAsync(String location, Context context) {
        return new PagedFlux(() -> this.listOSVersionsSinglePageAsync(location, context), nextLink -> this.listOSVersionsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OSVersionInner> listOSVersions(String location) {
        return new PagedIterable(this.listOSVersionsAsync(location));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OSVersionInner> listOSVersions(String location, Context context) {
        return new PagedIterable(this.listOSVersionsAsync(location, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<OSFamilyInner>> getOSFamilyWithResponseAsync(String location, String osFamilyName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (osFamilyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter osFamilyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-04-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOSFamily(this.client.getEndpoint(), location, osFamilyName, this.client.getSubscriptionId(), "2022-04-04", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<OSFamilyInner>> getOSFamilyWithResponseAsync(String location, String osFamilyName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (osFamilyName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter osFamilyName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-04-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getOSFamily(this.client.getEndpoint(), location, osFamilyName, this.client.getSubscriptionId(), "2022-04-04", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<OSFamilyInner> getOSFamilyAsync(String location, String osFamilyName) {
        return this.getOSFamilyWithResponseAsync(location, osFamilyName).flatMap(res -> Mono.justOrEmpty((Object)((OSFamilyInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OSFamilyInner getOSFamily(String location, String osFamilyName) {
        return (OSFamilyInner)this.getOSFamilyAsync(location, osFamilyName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<OSFamilyInner> getOSFamilyWithResponse(String location, String osFamilyName, Context context) {
        return (Response)this.getOSFamilyWithResponseAsync(location, osFamilyName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OSFamilyInner>> listOSFamiliesSinglePageAsync(String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-04-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOSFamilies(this.client.getEndpoint(), location, this.client.getSubscriptionId(), "2022-04-04", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OSFamilyListResult)res.getValue()).value(), ((OSFamilyListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OSFamilyInner>> listOSFamiliesSinglePageAsync(String location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-04-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listOSFamilies(this.client.getEndpoint(), location, this.client.getSubscriptionId(), "2022-04-04", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OSFamilyListResult)res.getValue()).value(), ((OSFamilyListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<OSFamilyInner> listOSFamiliesAsync(String location) {
        return new PagedFlux(() -> this.listOSFamiliesSinglePageAsync(location), nextLink -> this.listOSFamiliesNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<OSFamilyInner> listOSFamiliesAsync(String location, Context context) {
        return new PagedFlux(() -> this.listOSFamiliesSinglePageAsync(location, context), nextLink -> this.listOSFamiliesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OSFamilyInner> listOSFamilies(String location) {
        return new PagedIterable(this.listOSFamiliesAsync(location));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<OSFamilyInner> listOSFamilies(String location, Context context) {
        return new PagedIterable(this.listOSFamiliesAsync(location, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OSVersionInner>> listOSVersionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOSVersionsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OSVersionListResult)res.getValue()).value(), ((OSVersionListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OSVersionInner>> listOSVersionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listOSVersionsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OSVersionListResult)res.getValue()).value(), ((OSVersionListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OSFamilyInner>> listOSFamiliesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listOSFamiliesNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OSFamilyListResult)res.getValue()).value(), ((OSFamilyListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<OSFamilyInner>> listOSFamiliesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listOSFamiliesNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((OSFamilyListResult)res.getValue()).value(), ((OSFamilyListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    private static interface CloudServiceOperatingSystemsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/cloudServiceOsVersions/{osVersionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<OSVersionInner>> getOSVersion(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="osVersionName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/cloudServiceOsVersions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<OSVersionListResult>> listOSVersions(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/cloudServiceOsFamilies/{osFamilyName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<OSFamilyInner>> getOSFamily(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="osFamilyName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/cloudServiceOsFamilies")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<OSFamilyListResult>> listOSFamilies(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="subscriptionId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<OSVersionListResult>> listOSVersionsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<OSFamilyListResult>> listOSFamiliesNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

