/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.resourcemanager.compute.fluent.models.DiskEncryptionSetUpdateProperties;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetType;
import com.azure.resourcemanager.compute.models.EncryptionSetIdentity;
import com.azure.resourcemanager.compute.models.KeyForDiskEncryptionSet;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class DiskEncryptionSetUpdate {
    @JsonProperty(value="properties")
    private DiskEncryptionSetUpdateProperties innerProperties;
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="identity")
    private EncryptionSetIdentity identity;

    private DiskEncryptionSetUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public DiskEncryptionSetUpdate withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public EncryptionSetIdentity identity() {
        return this.identity;
    }

    public DiskEncryptionSetUpdate withIdentity(EncryptionSetIdentity identity) {
        this.identity = identity;
        return this;
    }

    public DiskEncryptionSetType encryptionType() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionType();
    }

    public DiskEncryptionSetUpdate withEncryptionType(DiskEncryptionSetType encryptionType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskEncryptionSetUpdateProperties();
        }
        this.innerProperties().withEncryptionType(encryptionType);
        return this;
    }

    public KeyForDiskEncryptionSet activeKey() {
        return this.innerProperties() == null ? null : this.innerProperties().activeKey();
    }

    public DiskEncryptionSetUpdate withActiveKey(KeyForDiskEncryptionSet activeKey) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskEncryptionSetUpdateProperties();
        }
        this.innerProperties().withActiveKey(activeKey);
        return this;
    }

    public Boolean rotationToLatestKeyVersionEnabled() {
        return this.innerProperties() == null ? null : this.innerProperties().rotationToLatestKeyVersionEnabled();
    }

    public DiskEncryptionSetUpdate withRotationToLatestKeyVersionEnabled(Boolean rotationToLatestKeyVersionEnabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskEncryptionSetUpdateProperties();
        }
        this.innerProperties().withRotationToLatestKeyVersionEnabled(rotationToLatestKeyVersionEnabled);
        return this;
    }

    public String federatedClientId() {
        return this.innerProperties() == null ? null : this.innerProperties().federatedClientId();
    }

    public DiskEncryptionSetUpdate withFederatedClientId(String federatedClientId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DiskEncryptionSetUpdateProperties();
        }
        this.innerProperties().withFederatedClientId(federatedClientId);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
    }
}

