// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.compute.fluent.models.CloudServiceRoleInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in CloudServiceRolesClient. */
public interface CloudServiceRolesClient {
    /**
     * Gets a role from a cloud service.
     *
     * @param roleName Name of the role.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role from a cloud service along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CloudServiceRoleInner>> getWithResponseAsync(
        String roleName, String resourceGroupName, String cloudServiceName);

    /**
     * Gets a role from a cloud service.
     *
     * @param roleName Name of the role.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role from a cloud service on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CloudServiceRoleInner> getAsync(String roleName, String resourceGroupName, String cloudServiceName);

    /**
     * Gets a role from a cloud service.
     *
     * @param roleName Name of the role.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role from a cloud service along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CloudServiceRoleInner> getWithResponse(
        String roleName, String resourceGroupName, String cloudServiceName, Context context);

    /**
     * Gets a role from a cloud service.
     *
     * @param roleName Name of the role.
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role from a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CloudServiceRoleInner get(String roleName, String resourceGroupName, String cloudServiceName);

    /**
     * Gets a list of all roles in a cloud service. Use nextLink property in the response to get the next page of roles.
     * Do this till nextLink is null to fetch all the roles.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all roles in a cloud service as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<CloudServiceRoleInner> listAsync(String resourceGroupName, String cloudServiceName);

    /**
     * Gets a list of all roles in a cloud service. Use nextLink property in the response to get the next page of roles.
     * Do this till nextLink is null to fetch all the roles.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all roles in a cloud service as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CloudServiceRoleInner> list(String resourceGroupName, String cloudServiceName);

    /**
     * Gets a list of all roles in a cloud service. Use nextLink property in the response to get the next page of roles.
     * Do this till nextLink is null to fetch all the roles.
     *
     * @param resourceGroupName Name of the resource group.
     * @param cloudServiceName Name of the cloud service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a list of all roles in a cloud service as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<CloudServiceRoleInner> list(String resourceGroupName, String cloudServiceName, Context context);
}
