// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.models.AccessUriInner;
import com.azure.resourcemanager.compute.fluent.models.SnapshotInner;
import com.azure.resourcemanager.compute.models.GrantAccessData;
import com.azure.resourcemanager.compute.models.SnapshotUpdate;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in SnapshotsClient. */
public interface SnapshotsClient
    extends InnerSupportsGet<SnapshotInner>, InnerSupportsListing<SnapshotInner>, InnerSupportsDelete<Void> {
    /**
     * Creates or updates a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Put disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return snapshot resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String snapshotName, SnapshotInner snapshot);

    /**
     * Creates or updates a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Put disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of snapshot resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<SnapshotInner>, SnapshotInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String snapshotName, SnapshotInner snapshot);

    /**
     * Creates or updates a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Put disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of snapshot resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SnapshotInner>, SnapshotInner> beginCreateOrUpdate(
        String resourceGroupName, String snapshotName, SnapshotInner snapshot);

    /**
     * Creates or updates a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Put disk operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of snapshot resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SnapshotInner>, SnapshotInner> beginCreateOrUpdate(
        String resourceGroupName, String snapshotName, SnapshotInner snapshot, Context context);

    /**
     * Creates or updates a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Put disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return snapshot resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SnapshotInner> createOrUpdateAsync(String resourceGroupName, String snapshotName, SnapshotInner snapshot);

    /**
     * Creates or updates a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Put disk operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return snapshot resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SnapshotInner createOrUpdate(String resourceGroupName, String snapshotName, SnapshotInner snapshot);

    /**
     * Creates or updates a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Put disk operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return snapshot resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SnapshotInner createOrUpdate(
        String resourceGroupName, String snapshotName, SnapshotInner snapshot, Context context);

    /**
     * Updates (patches) a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Patch snapshot operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return snapshot resource along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(
        String resourceGroupName, String snapshotName, SnapshotUpdate snapshot);

    /**
     * Updates (patches) a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Patch snapshot operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of snapshot resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<SnapshotInner>, SnapshotInner> beginUpdateAsync(
        String resourceGroupName, String snapshotName, SnapshotUpdate snapshot);

    /**
     * Updates (patches) a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Patch snapshot operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of snapshot resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SnapshotInner>, SnapshotInner> beginUpdate(
        String resourceGroupName, String snapshotName, SnapshotUpdate snapshot);

    /**
     * Updates (patches) a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Patch snapshot operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of snapshot resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SnapshotInner>, SnapshotInner> beginUpdate(
        String resourceGroupName, String snapshotName, SnapshotUpdate snapshot, Context context);

    /**
     * Updates (patches) a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Patch snapshot operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return snapshot resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SnapshotInner> updateAsync(String resourceGroupName, String snapshotName, SnapshotUpdate snapshot);

    /**
     * Updates (patches) a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Patch snapshot operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return snapshot resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SnapshotInner update(String resourceGroupName, String snapshotName, SnapshotUpdate snapshot);

    /**
     * Updates (patches) a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param snapshot Snapshot object supplied in the body of the Patch snapshot operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return snapshot resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SnapshotInner update(String resourceGroupName, String snapshotName, SnapshotUpdate snapshot, Context context);

    /**
     * Gets information about a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a snapshot along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SnapshotInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String snapshotName);

    /**
     * Gets information about a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a snapshot on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SnapshotInner> getByResourceGroupAsync(String resourceGroupName, String snapshotName);

    /**
     * Gets information about a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a snapshot along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SnapshotInner> getByResourceGroupWithResponse(
        String resourceGroupName, String snapshotName, Context context);

    /**
     * Gets information about a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information about a snapshot.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SnapshotInner getByResourceGroup(String resourceGroupName, String snapshotName);

    /**
     * Deletes a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String snapshotName);

    /**
     * Deletes a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String snapshotName);

    /**
     * Deletes a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String snapshotName);

    /**
     * Deletes a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String snapshotName, Context context);

    /**
     * Deletes a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String snapshotName);

    /**
     * Deletes a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String snapshotName);

    /**
     * Deletes a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String snapshotName, Context context);

    /**
     * Lists snapshots under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Snapshots operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SnapshotInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Lists snapshots under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Snapshots operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SnapshotInner> listByResourceGroup(String resourceGroupName);

    /**
     * Lists snapshots under a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Snapshots operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SnapshotInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Lists snapshots under a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Snapshots operation response as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<SnapshotInner> listAsync();

    /**
     * Lists snapshots under a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Snapshots operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SnapshotInner> list();

    /**
     * Lists snapshots under a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Snapshots operation response as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<SnapshotInner> list(Context context);

    /**
     * Grants access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param grantAccessData Access data object supplied in the body of the get snapshot access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a disk access SAS uri along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> grantAccessWithResponseAsync(
        String resourceGroupName, String snapshotName, GrantAccessData grantAccessData);

    /**
     * Grants access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param grantAccessData Access data object supplied in the body of the get snapshot access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a disk access SAS uri.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<AccessUriInner>, AccessUriInner> beginGrantAccessAsync(
        String resourceGroupName, String snapshotName, GrantAccessData grantAccessData);

    /**
     * Grants access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param grantAccessData Access data object supplied in the body of the get snapshot access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a disk access SAS uri.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<AccessUriInner>, AccessUriInner> beginGrantAccess(
        String resourceGroupName, String snapshotName, GrantAccessData grantAccessData);

    /**
     * Grants access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param grantAccessData Access data object supplied in the body of the get snapshot access operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a disk access SAS uri.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<AccessUriInner>, AccessUriInner> beginGrantAccess(
        String resourceGroupName, String snapshotName, GrantAccessData grantAccessData, Context context);

    /**
     * Grants access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param grantAccessData Access data object supplied in the body of the get snapshot access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a disk access SAS uri on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AccessUriInner> grantAccessAsync(
        String resourceGroupName, String snapshotName, GrantAccessData grantAccessData);

    /**
     * Grants access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param grantAccessData Access data object supplied in the body of the get snapshot access operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a disk access SAS uri.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AccessUriInner grantAccess(String resourceGroupName, String snapshotName, GrantAccessData grantAccessData);

    /**
     * Grants access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param grantAccessData Access data object supplied in the body of the get snapshot access operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a disk access SAS uri.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AccessUriInner grantAccess(
        String resourceGroupName, String snapshotName, GrantAccessData grantAccessData, Context context);

    /**
     * Revokes access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> revokeAccessWithResponseAsync(String resourceGroupName, String snapshotName);

    /**
     * Revokes access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginRevokeAccessAsync(String resourceGroupName, String snapshotName);

    /**
     * Revokes access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRevokeAccess(String resourceGroupName, String snapshotName);

    /**
     * Revokes access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginRevokeAccess(
        String resourceGroupName, String snapshotName, Context context);

    /**
     * Revokes access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> revokeAccessAsync(String resourceGroupName, String snapshotName);

    /**
     * Revokes access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void revokeAccess(String resourceGroupName, String snapshotName);

    /**
     * Revokes access to a snapshot.
     *
     * @param resourceGroupName The name of the resource group.
     * @param snapshotName The name of the snapshot that is being created. The name can't be changed after the snapshot
     *     is created. Supported characters for the name are a-z, A-Z, 0-9, _ and -. The max name length is 80
     *     characters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void revokeAccess(String resourceGroupName, String snapshotName, Context context);
}
