// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The instance view of a virtual machine boot diagnostics. */
@Immutable
public final class BootDiagnosticsInstanceView {
    /*
     * The console screenshot blob URI. **Note:** This will **not** be set if boot diagnostics is currently enabled
     * with managed storage.
     */
    @JsonProperty(value = "consoleScreenshotBlobUri", access = JsonProperty.Access.WRITE_ONLY)
    private String consoleScreenshotBlobUri;

    /*
     * The serial console log blob Uri. **Note:** This will **not** be set if boot diagnostics is currently enabled
     * with managed storage.
     */
    @JsonProperty(value = "serialConsoleLogBlobUri", access = JsonProperty.Access.WRITE_ONLY)
    private String serialConsoleLogBlobUri;

    /*
     * The boot diagnostics status information for the VM. **Note:** It will be set only if there are errors
     * encountered in enabling boot diagnostics.
     */
    @JsonProperty(value = "status", access = JsonProperty.Access.WRITE_ONLY)
    private InstanceViewStatus status;

    /** Creates an instance of BootDiagnosticsInstanceView class. */
    public BootDiagnosticsInstanceView() {
    }

    /**
     * Get the consoleScreenshotBlobUri property: The console screenshot blob URI. **Note:** This will **not** be set if
     * boot diagnostics is currently enabled with managed storage.
     *
     * @return the consoleScreenshotBlobUri value.
     */
    public String consoleScreenshotBlobUri() {
        return this.consoleScreenshotBlobUri;
    }

    /**
     * Get the serialConsoleLogBlobUri property: The serial console log blob Uri. **Note:** This will **not** be set if
     * boot diagnostics is currently enabled with managed storage.
     *
     * @return the serialConsoleLogBlobUri value.
     */
    public String serialConsoleLogBlobUri() {
        return this.serialConsoleLogBlobUri;
    }

    /**
     * Get the status property: The boot diagnostics status information for the VM. **Note:** It will be set only if
     * there are errors encountered in enabling boot diagnostics.
     *
     * @return the status value.
     */
    public InstanceViewStatus status() {
        return this.status;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (status() != null) {
            status().validate();
        }
    }
}
