// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Used to specify the file format when making request for SAS on a VHDX file format snapshot. */
public final class FileFormat extends ExpandableStringEnum<FileFormat> {
    /** Static value VHD for FileFormat. */
    public static final FileFormat VHD = fromString("VHD");

    /** Static value VHDX for FileFormat. */
    public static final FileFormat VHDX = fromString("VHDX");

    /**
     * Creates a new instance of FileFormat value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public FileFormat() {
    }

    /**
     * Creates or finds a FileFormat from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding FileFormat.
     */
    @JsonCreator
    public static FileFormat fromString(String name) {
        return fromString(name, FileFormat.class);
    }

    /**
     * Gets known FileFormat values.
     *
     * @return known FileFormat values.
     */
    public static Collection<FileFormat> values() {
        return values(FileFormat.class);
    }
}
