// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The definition of a parameter that can be passed to a custom action of a Gallery Application Version. */
@Fluent
public final class GalleryApplicationCustomActionParameter {
    /*
     * The name of the custom action.  Must be unique within the Gallery Application Version.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * Indicates whether this parameter must be passed when running the custom action.
     */
    @JsonProperty(value = "required")
    private Boolean required;

    /*
     * Specifies the type of the custom action parameter. Possible values are: String, ConfigurationDataBlob or
     * LogOutputBlob
     */
    @JsonProperty(value = "type")
    private GalleryApplicationCustomActionParameterType type;

    /*
     * The default value of the parameter.  Only applies to string types
     */
    @JsonProperty(value = "defaultValue")
    private String defaultValue;

    /*
     * A description to help users understand what this parameter means
     */
    @JsonProperty(value = "description")
    private String description;

    /** Creates an instance of GalleryApplicationCustomActionParameter class. */
    public GalleryApplicationCustomActionParameter() {
    }

    /**
     * Get the name property: The name of the custom action. Must be unique within the Gallery Application Version.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the custom action. Must be unique within the Gallery Application Version.
     *
     * @param name the name value to set.
     * @return the GalleryApplicationCustomActionParameter object itself.
     */
    public GalleryApplicationCustomActionParameter withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the required property: Indicates whether this parameter must be passed when running the custom action.
     *
     * @return the required value.
     */
    public Boolean required() {
        return this.required;
    }

    /**
     * Set the required property: Indicates whether this parameter must be passed when running the custom action.
     *
     * @param required the required value to set.
     * @return the GalleryApplicationCustomActionParameter object itself.
     */
    public GalleryApplicationCustomActionParameter withRequired(Boolean required) {
        this.required = required;
        return this;
    }

    /**
     * Get the type property: Specifies the type of the custom action parameter. Possible values are: String,
     * ConfigurationDataBlob or LogOutputBlob.
     *
     * @return the type value.
     */
    public GalleryApplicationCustomActionParameterType type() {
        return this.type;
    }

    /**
     * Set the type property: Specifies the type of the custom action parameter. Possible values are: String,
     * ConfigurationDataBlob or LogOutputBlob.
     *
     * @param type the type value to set.
     * @return the GalleryApplicationCustomActionParameter object itself.
     */
    public GalleryApplicationCustomActionParameter withType(GalleryApplicationCustomActionParameterType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the defaultValue property: The default value of the parameter. Only applies to string types.
     *
     * @return the defaultValue value.
     */
    public String defaultValue() {
        return this.defaultValue;
    }

    /**
     * Set the defaultValue property: The default value of the parameter. Only applies to string types.
     *
     * @param defaultValue the defaultValue value to set.
     * @return the GalleryApplicationCustomActionParameter object itself.
     */
    public GalleryApplicationCustomActionParameter withDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    /**
     * Get the description property: A description to help users understand what this parameter means.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description to help users understand what this parameter means.
     *
     * @param description the description value to set.
     * @return the GalleryApplicationCustomActionParameter object itself.
     */
    public GalleryApplicationCustomActionParameter withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property name in model GalleryApplicationCustomActionParameter"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryApplicationCustomActionParameter.class);
}
