// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Specifies the type of the custom action parameter. Possible values are: String, ConfigurationDataBlob or
 * LogOutputBlob.
 */
public enum GalleryApplicationCustomActionParameterType {
    /** Enum value String. */
    STRING("String"),

    /** Enum value ConfigurationDataBlob. */
    CONFIGURATION_DATA_BLOB("ConfigurationDataBlob"),

    /** Enum value LogOutputBlob. */
    LOG_OUTPUT_BLOB("LogOutputBlob");

    /** The actual serialized value for a GalleryApplicationCustomActionParameterType instance. */
    private final String value;

    GalleryApplicationCustomActionParameterType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a GalleryApplicationCustomActionParameterType instance.
     *
     * @param value the serialized value to parse.
     * @return the parsed GalleryApplicationCustomActionParameterType object, or null if unable to parse.
     */
    @JsonCreator
    public static GalleryApplicationCustomActionParameterType fromString(String value) {
        if (value == null) {
            return null;
        }
        GalleryApplicationCustomActionParameterType[] items = GalleryApplicationCustomActionParameterType.values();
        for (GalleryApplicationCustomActionParameterType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /** {@inheritDoc} */
    @JsonValue
    @Override
    public String toString() {
        return this.value;
    }
}
