// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Describes an Operating System disk. */
@Fluent
public final class ImageOSDisk extends ImageDisk {
    /*
     * This property allows you to specify the type of the OS that is included in the disk if creating a VM from a
     * custom image. Possible values are: **Windows,** **Linux.**
     */
    @JsonProperty(value = "osType", required = true)
    private OperatingSystemTypes osType;

    /*
     * The OS State. For managed images, use Generalized.
     */
    @JsonProperty(value = "osState", required = true)
    private OperatingSystemStateTypes osState;

    /** Creates an instance of ImageOSDisk class. */
    public ImageOSDisk() {
    }

    /**
     * Get the osType property: This property allows you to specify the type of the OS that is included in the disk if
     * creating a VM from a custom image. Possible values are: **Windows,** **Linux.**.
     *
     * @return the osType value.
     */
    public OperatingSystemTypes osType() {
        return this.osType;
    }

    /**
     * Set the osType property: This property allows you to specify the type of the OS that is included in the disk if
     * creating a VM from a custom image. Possible values are: **Windows,** **Linux.**.
     *
     * @param osType the osType value to set.
     * @return the ImageOSDisk object itself.
     */
    public ImageOSDisk withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the osState property: The OS State. For managed images, use Generalized.
     *
     * @return the osState value.
     */
    public OperatingSystemStateTypes osState() {
        return this.osState;
    }

    /**
     * Set the osState property: The OS State. For managed images, use Generalized.
     *
     * @param osState the osState value to set.
     * @return the ImageOSDisk object itself.
     */
    public ImageOSDisk withOsState(OperatingSystemStateTypes osState) {
        this.osState = osState;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ImageOSDisk withSnapshot(SubResource snapshot) {
        super.withSnapshot(snapshot);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ImageOSDisk withManagedDisk(SubResource managedDisk) {
        super.withManagedDisk(managedDisk);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ImageOSDisk withBlobUri(String blobUri) {
        super.withBlobUri(blobUri);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ImageOSDisk withCaching(CachingTypes caching) {
        super.withCaching(caching);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ImageOSDisk withDiskSizeGB(Integer diskSizeGB) {
        super.withDiskSizeGB(diskSizeGB);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ImageOSDisk withStorageAccountType(StorageAccountTypes storageAccountType) {
        super.withStorageAccountType(storageAccountType);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ImageOSDisk withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        super.withDiskEncryptionSet(diskEncryptionSet);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (osType() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property osType in model ImageOSDisk"));
        }
        if (osState() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property osState in model ImageOSDisk"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ImageOSDisk.class);
}
