// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Describes a storage profile. */
@Fluent
public final class ImageStorageProfile {
    /*
     * Specifies information about the operating system disk used by the virtual machine. <br><br> For more information
     * about disks, see [About disks and VHDs for Azure virtual
     * machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JsonProperty(value = "osDisk")
    private ImageOSDisk osDisk;

    /*
     * Specifies the parameters that are used to add a data disk to a virtual machine. <br><br> For more information
     * about disks, see [About disks and VHDs for Azure virtual
     * machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     */
    @JsonProperty(value = "dataDisks")
    private List<ImageDataDisk> dataDisks;

    /*
     * Specifies whether an image is zone resilient or not. Default is false. Zone resilient images can be created only
     * in regions that provide Zone Redundant Storage (ZRS).
     */
    @JsonProperty(value = "zoneResilient")
    private Boolean zoneResilient;

    /** Creates an instance of ImageStorageProfile class. */
    public ImageStorageProfile() {
    }

    /**
     * Get the osDisk property: Specifies information about the operating system disk used by the virtual machine.
     * &lt;br&gt;&lt;br&gt; For more information about disks, see [About disks and VHDs for Azure virtual
     * machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     *
     * @return the osDisk value.
     */
    public ImageOSDisk osDisk() {
        return this.osDisk;
    }

    /**
     * Set the osDisk property: Specifies information about the operating system disk used by the virtual machine.
     * &lt;br&gt;&lt;br&gt; For more information about disks, see [About disks and VHDs for Azure virtual
     * machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     *
     * @param osDisk the osDisk value to set.
     * @return the ImageStorageProfile object itself.
     */
    public ImageStorageProfile withOsDisk(ImageOSDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    /**
     * Get the dataDisks property: Specifies the parameters that are used to add a data disk to a virtual machine.
     * &lt;br&gt;&lt;br&gt; For more information about disks, see [About disks and VHDs for Azure virtual
     * machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     *
     * @return the dataDisks value.
     */
    public List<ImageDataDisk> dataDisks() {
        return this.dataDisks;
    }

    /**
     * Set the dataDisks property: Specifies the parameters that are used to add a data disk to a virtual machine.
     * &lt;br&gt;&lt;br&gt; For more information about disks, see [About disks and VHDs for Azure virtual
     * machines](https://docs.microsoft.com/azure/virtual-machines/managed-disks-overview).
     *
     * @param dataDisks the dataDisks value to set.
     * @return the ImageStorageProfile object itself.
     */
    public ImageStorageProfile withDataDisks(List<ImageDataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    /**
     * Get the zoneResilient property: Specifies whether an image is zone resilient or not. Default is false. Zone
     * resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
     *
     * @return the zoneResilient value.
     */
    public Boolean zoneResilient() {
        return this.zoneResilient;
    }

    /**
     * Set the zoneResilient property: Specifies whether an image is zone resilient or not. Default is false. Zone
     * resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
     *
     * @param zoneResilient the zoneResilient value to set.
     * @return the ImageStorageProfile object itself.
     */
    public ImageStorageProfile withZoneResilient(Boolean zoneResilient) {
        this.zoneResilient = zoneResilient;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (osDisk() != null) {
            osDisk().validate();
        }
        if (dataDisks() != null) {
            dataDisks().forEach(e -> e.validate());
        }
    }
}
