// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Encryption at rest settings for disk restore point. It is an optional property that can be specified in the input
 * while creating a restore point.
 */
@Fluent
public final class RestorePointEncryption {
    /*
     * Describes the parameter of customer managed disk encryption set resource id that can be specified for disk.
     * **Note:** The disk encryption set resource id can only be specified for managed disk. Please refer
     * https://aka.ms/mdssewithcmkoverview for more details.
     */
    @JsonProperty(value = "diskEncryptionSet")
    private DiskEncryptionSetParameters diskEncryptionSet;

    /*
     * The type of key used to encrypt the data of the disk restore point.
     */
    @JsonProperty(value = "type")
    private RestorePointEncryptionType type;

    /** Creates an instance of RestorePointEncryption class. */
    public RestorePointEncryption() {
    }

    /**
     * Get the diskEncryptionSet property: Describes the parameter of customer managed disk encryption set resource id
     * that can be specified for disk. **Note:** The disk encryption set resource id can only be specified for managed
     * disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.
     *
     * @return the diskEncryptionSet value.
     */
    public DiskEncryptionSetParameters diskEncryptionSet() {
        return this.diskEncryptionSet;
    }

    /**
     * Set the diskEncryptionSet property: Describes the parameter of customer managed disk encryption set resource id
     * that can be specified for disk. **Note:** The disk encryption set resource id can only be specified for managed
     * disk. Please refer https://aka.ms/mdssewithcmkoverview for more details.
     *
     * @param diskEncryptionSet the diskEncryptionSet value to set.
     * @return the RestorePointEncryption object itself.
     */
    public RestorePointEncryption withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        this.diskEncryptionSet = diskEncryptionSet;
        return this;
    }

    /**
     * Get the type property: The type of key used to encrypt the data of the disk restore point.
     *
     * @return the type value.
     */
    public RestorePointEncryptionType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of key used to encrypt the data of the disk restore point.
     *
     * @param type the type value to set.
     * @return the RestorePointEncryption object itself.
     */
    public RestorePointEncryption withType(RestorePointEncryptionType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (diskEncryptionSet() != null) {
            diskEncryptionSet().validate();
        }
    }
}
