// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** List of supported capabilities persisted on the disk resource for VM use. */
@Fluent
public final class SupportedCapabilities {
    /*
     * The disk controllers that an OS disk supports. If set it can be SCSI or SCSI, NVME or NVME, SCSI.
     */
    @JsonProperty(value = "diskControllerTypes")
    private String diskControllerTypes;

    /*
     * True if the image from which the OS disk is created supports accelerated networking.
     */
    @JsonProperty(value = "acceleratedNetwork")
    private Boolean acceleratedNetwork;

    /*
     * CPU architecture supported by an OS disk.
     */
    @JsonProperty(value = "architecture")
    private Architecture architecture;

    /** Creates an instance of SupportedCapabilities class. */
    public SupportedCapabilities() {
    }

    /**
     * Get the diskControllerTypes property: The disk controllers that an OS disk supports. If set it can be SCSI or
     * SCSI, NVME or NVME, SCSI.
     *
     * @return the diskControllerTypes value.
     */
    public String diskControllerTypes() {
        return this.diskControllerTypes;
    }

    /**
     * Set the diskControllerTypes property: The disk controllers that an OS disk supports. If set it can be SCSI or
     * SCSI, NVME or NVME, SCSI.
     *
     * @param diskControllerTypes the diskControllerTypes value to set.
     * @return the SupportedCapabilities object itself.
     */
    public SupportedCapabilities withDiskControllerTypes(String diskControllerTypes) {
        this.diskControllerTypes = diskControllerTypes;
        return this;
    }

    /**
     * Get the acceleratedNetwork property: True if the image from which the OS disk is created supports accelerated
     * networking.
     *
     * @return the acceleratedNetwork value.
     */
    public Boolean acceleratedNetwork() {
        return this.acceleratedNetwork;
    }

    /**
     * Set the acceleratedNetwork property: True if the image from which the OS disk is created supports accelerated
     * networking.
     *
     * @param acceleratedNetwork the acceleratedNetwork value to set.
     * @return the SupportedCapabilities object itself.
     */
    public SupportedCapabilities withAcceleratedNetwork(Boolean acceleratedNetwork) {
        this.acceleratedNetwork = acceleratedNetwork;
        return this;
    }

    /**
     * Get the architecture property: CPU architecture supported by an OS disk.
     *
     * @return the architecture value.
     */
    public Architecture architecture() {
        return this.architecture;
    }

    /**
     * Set the architecture property: CPU architecture supported by an OS disk.
     *
     * @param architecture the architecture value to set.
     * @return the SupportedCapabilities object itself.
     */
    public SupportedCapabilities withArchitecture(Architecture architecture) {
        this.architecture = architecture;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
