/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.CloudServicesUpdateDomainsClient;
import com.azure.resourcemanager.compute.fluent.models.UpdateDomainInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.UpdateDomainListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CloudServicesUpdateDomainsClientImpl
implements CloudServicesUpdateDomainsClient {
    private final CloudServicesUpdateDomainsService service;
    private final ComputeManagementClientImpl client;

    CloudServicesUpdateDomainsClientImpl(ComputeManagementClientImpl client) {
        this.service = (CloudServicesUpdateDomainsService)RestProxy.create(CloudServicesUpdateDomainsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> walkUpdateDomainWithResponseAsync(String resourceGroupName, String cloudServiceName, int updateDomain, UpdateDomainInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String apiVersion = "2022-09-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.walkUpdateDomain(this.client.getEndpoint(), resourceGroupName, cloudServiceName, updateDomain, this.client.getSubscriptionId(), "2022-09-04", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> walkUpdateDomainWithResponseAsync(String resourceGroupName, String cloudServiceName, int updateDomain, UpdateDomainInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters != null) {
            parameters.validate();
        }
        String apiVersion = "2022-09-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.walkUpdateDomain(this.client.getEndpoint(), resourceGroupName, cloudServiceName, updateDomain, this.client.getSubscriptionId(), "2022-09-04", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginWalkUpdateDomainAsync(String resourceGroupName, String cloudServiceName, int updateDomain, UpdateDomainInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.walkUpdateDomainWithResponseAsync(resourceGroupName, cloudServiceName, updateDomain, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginWalkUpdateDomainAsync(String resourceGroupName, String cloudServiceName, int updateDomain) {
        UpdateDomainInner parameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.walkUpdateDomainWithResponseAsync(resourceGroupName, cloudServiceName, updateDomain, parameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginWalkUpdateDomainAsync(String resourceGroupName, String cloudServiceName, int updateDomain, UpdateDomainInner parameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.walkUpdateDomainWithResponseAsync(resourceGroupName, cloudServiceName, updateDomain, parameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginWalkUpdateDomain(String resourceGroupName, String cloudServiceName, int updateDomain) {
        UpdateDomainInner parameters = null;
        return this.beginWalkUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain, parameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginWalkUpdateDomain(String resourceGroupName, String cloudServiceName, int updateDomain, UpdateDomainInner parameters, Context context) {
        return this.beginWalkUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain, parameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> walkUpdateDomainAsync(String resourceGroupName, String cloudServiceName, int updateDomain, UpdateDomainInner parameters) {
        return this.beginWalkUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> walkUpdateDomainAsync(String resourceGroupName, String cloudServiceName, int updateDomain) {
        UpdateDomainInner parameters = null;
        return this.beginWalkUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain, parameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> walkUpdateDomainAsync(String resourceGroupName, String cloudServiceName, int updateDomain, UpdateDomainInner parameters, Context context) {
        return this.beginWalkUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain, parameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void walkUpdateDomain(String resourceGroupName, String cloudServiceName, int updateDomain) {
        UpdateDomainInner parameters = null;
        this.walkUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain, parameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void walkUpdateDomain(String resourceGroupName, String cloudServiceName, int updateDomain, UpdateDomainInner parameters, Context context) {
        this.walkUpdateDomainAsync(resourceGroupName, cloudServiceName, updateDomain, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<UpdateDomainInner>> getUpdateDomainWithResponseAsync(String resourceGroupName, String cloudServiceName, int updateDomain) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-09-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getUpdateDomain(this.client.getEndpoint(), resourceGroupName, cloudServiceName, updateDomain, this.client.getSubscriptionId(), "2022-09-04", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<UpdateDomainInner>> getUpdateDomainWithResponseAsync(String resourceGroupName, String cloudServiceName, int updateDomain, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-09-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getUpdateDomain(this.client.getEndpoint(), resourceGroupName, cloudServiceName, updateDomain, this.client.getSubscriptionId(), "2022-09-04", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<UpdateDomainInner> getUpdateDomainAsync(String resourceGroupName, String cloudServiceName, int updateDomain) {
        return this.getUpdateDomainWithResponseAsync(resourceGroupName, cloudServiceName, updateDomain).flatMap(res -> Mono.justOrEmpty((Object)((UpdateDomainInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<UpdateDomainInner> getUpdateDomainWithResponse(String resourceGroupName, String cloudServiceName, int updateDomain, Context context) {
        return (Response)this.getUpdateDomainWithResponseAsync(resourceGroupName, cloudServiceName, updateDomain, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public UpdateDomainInner getUpdateDomain(String resourceGroupName, String cloudServiceName, int updateDomain) {
        return (UpdateDomainInner)this.getUpdateDomainWithResponse(resourceGroupName, cloudServiceName, updateDomain, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UpdateDomainInner>> listUpdateDomainsSinglePageAsync(String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-09-04";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listUpdateDomains(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2022-09-04", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UpdateDomainListResult)res.getValue()).value(), ((UpdateDomainListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UpdateDomainInner>> listUpdateDomainsSinglePageAsync(String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2022-09-04";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listUpdateDomains(this.client.getEndpoint(), resourceGroupName, cloudServiceName, this.client.getSubscriptionId(), "2022-09-04", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UpdateDomainListResult)res.getValue()).value(), ((UpdateDomainListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<UpdateDomainInner> listUpdateDomainsAsync(String resourceGroupName, String cloudServiceName) {
        return new PagedFlux(() -> this.listUpdateDomainsSinglePageAsync(resourceGroupName, cloudServiceName), nextLink -> this.listUpdateDomainsNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<UpdateDomainInner> listUpdateDomainsAsync(String resourceGroupName, String cloudServiceName, Context context) {
        return new PagedFlux(() -> this.listUpdateDomainsSinglePageAsync(resourceGroupName, cloudServiceName, context), nextLink -> this.listUpdateDomainsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<UpdateDomainInner> listUpdateDomains(String resourceGroupName, String cloudServiceName) {
        return new PagedIterable(this.listUpdateDomainsAsync(resourceGroupName, cloudServiceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<UpdateDomainInner> listUpdateDomains(String resourceGroupName, String cloudServiceName, Context context) {
        return new PagedIterable(this.listUpdateDomainsAsync(resourceGroupName, cloudServiceName, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UpdateDomainInner>> listUpdateDomainsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listUpdateDomainsNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UpdateDomainListResult)res.getValue()).value(), ((UpdateDomainListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<UpdateDomainInner>> listUpdateDomainsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listUpdateDomainsNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((UpdateDomainListResult)res.getValue()).value(), ((UpdateDomainListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    public static interface CloudServicesUpdateDomainsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/updateDomains/{updateDomain}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> walkUpdateDomain(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="updateDomain") int var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") UpdateDomainInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/updateDomains/{updateDomain}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<UpdateDomainInner>> getUpdateDomain(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="updateDomain") int var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/cloudServices/{cloudServiceName}/updateDomains")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<UpdateDomainListResult>> listUpdateDomains(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="cloudServiceName") String var3, @PathParam(value="subscriptionId") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<UpdateDomainListResult>> listUpdateDomainsNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

