/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.VirtualMachineRunCommandsClient;
import com.azure.resourcemanager.compute.fluent.models.RunCommandDocumentBaseInner;
import com.azure.resourcemanager.compute.fluent.models.RunCommandDocumentInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineRunCommandInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.RunCommandListResult;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandUpdate;
import com.azure.resourcemanager.compute.models.VirtualMachineRunCommandsListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VirtualMachineRunCommandsClientImpl
implements VirtualMachineRunCommandsClient {
    private final VirtualMachineRunCommandsService service;
    private final ComputeManagementClientImpl client;

    VirtualMachineRunCommandsClientImpl(ComputeManagementClientImpl client) {
        this.service = (VirtualMachineRunCommandsService)RestProxy.create(VirtualMachineRunCommandsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RunCommandDocumentBaseInner>> listSinglePageAsync(String location) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), location, "2024-03-01", this.client.getSubscriptionId(), "application/json, text/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RunCommandListResult)res.getValue()).value(), ((RunCommandListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RunCommandDocumentBaseInner>> listSinglePageAsync(String location, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), location, "2024-03-01", this.client.getSubscriptionId(), "application/json, text/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RunCommandListResult)res.getValue()).value(), ((RunCommandListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RunCommandDocumentBaseInner> listAsync(String location) {
        return new PagedFlux(() -> this.listSinglePageAsync(location), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RunCommandDocumentBaseInner> listAsync(String location, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(location, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RunCommandDocumentBaseInner> list(String location) {
        return new PagedIterable(this.listAsync(location));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RunCommandDocumentBaseInner> list(String location, Context context) {
        return new PagedIterable(this.listAsync(location, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RunCommandDocumentInner>> getWithResponseAsync(String location, String commandId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (commandId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter commandId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), location, commandId, "2024-03-01", this.client.getSubscriptionId(), "application/json, text/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RunCommandDocumentInner>> getWithResponseAsync(String location, String commandId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (location == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter location is required and cannot be null."));
        }
        if (commandId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter commandId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), location, commandId, "2024-03-01", this.client.getSubscriptionId(), "application/json, text/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunCommandDocumentInner> getAsync(String location, String commandId) {
        return this.getWithResponseAsync(location, commandId).flatMap(res -> Mono.justOrEmpty((Object)((RunCommandDocumentInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RunCommandDocumentInner> getWithResponse(String location, String commandId, Context context) {
        return (Response)this.getWithResponseAsync(location, commandId, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunCommandDocumentInner get(String location, String commandId) {
        return (RunCommandDocumentInner)this.getWithResponse(location, commandId, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (runCommand == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runCommand is required and cannot be null."));
        }
        runCommand.validate();
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName, "2024-03-01", this.client.getSubscriptionId(), runCommand, "application/json, text/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (runCommand == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runCommand is required and cannot be null."));
        }
        runCommand.validate();
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName, "2024-03-01", this.client.getSubscriptionId(), runCommand, "application/json, text/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, vmName, runCommandName, runCommand);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineRunCommandInner.class), (Type)((Object)VirtualMachineRunCommandInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, vmName, runCommandName, runCommand, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineRunCommandInner.class), (Type)((Object)VirtualMachineRunCommandInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginCreateOrUpdate(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginCreateOrUpdate(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualMachineRunCommandInner> createOrUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineRunCommandInner createOrUpdate(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand) {
        return (VirtualMachineRunCommandInner)((Object)this.createOrUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineRunCommandInner createOrUpdate(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandInner runCommand, Context context) {
        return (VirtualMachineRunCommandInner)((Object)this.createOrUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (runCommand == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runCommand is required and cannot be null."));
        }
        runCommand.validate();
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName, "2024-03-01", this.client.getSubscriptionId(), runCommand, "application/json, text/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (runCommand == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runCommand is required and cannot be null."));
        }
        runCommand.validate();
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName, "2024-03-01", this.client.getSubscriptionId(), runCommand, "application/json, text/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, vmName, runCommandName, runCommand);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineRunCommandInner.class), (Type)((Object)VirtualMachineRunCommandInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, vmName, runCommandName, runCommand, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineRunCommandInner.class), (Type)((Object)VirtualMachineRunCommandInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdate(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return this.beginUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualMachineRunCommandInner>, VirtualMachineRunCommandInner> beginUpdate(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand, Context context) {
        return this.beginUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return this.beginUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualMachineRunCommandInner> updateAsync(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand, Context context) {
        return this.beginUpdateAsync(resourceGroupName, vmName, runCommandName, runCommand, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineRunCommandInner update(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand) {
        return (VirtualMachineRunCommandInner)((Object)this.updateAsync(resourceGroupName, vmName, runCommandName, runCommand).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineRunCommandInner update(String resourceGroupName, String vmName, String runCommandName, VirtualMachineRunCommandUpdate runCommand, Context context) {
        return (VirtualMachineRunCommandInner)((Object)this.updateAsync(resourceGroupName, vmName, runCommandName, runCommand, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmName, String runCommandName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName, "2024-03-01", this.client.getSubscriptionId(), "application/json, text/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmName, String runCommandName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName, "2024-03-01", this.client.getSubscriptionId(), "application/json, text/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmName, String runCommandName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, vmName, runCommandName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmName, String runCommandName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, vmName, runCommandName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmName, String runCommandName) {
        return this.beginDeleteAsync(resourceGroupName, vmName, runCommandName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmName, String runCommandName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, vmName, runCommandName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String vmName, String runCommandName) {
        return this.beginDeleteAsync(resourceGroupName, vmName, runCommandName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String vmName, String runCommandName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, vmName, runCommandName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String vmName, String runCommandName) {
        this.deleteAsync(resourceGroupName, vmName, runCommandName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String vmName, String runCommandName, Context context) {
        this.deleteAsync(resourceGroupName, vmName, runCommandName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VirtualMachineRunCommandInner>> getByVirtualMachineWithResponseAsync(String resourceGroupName, String vmName, String runCommandName, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.getByVirtualMachine(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName, expand, "2024-03-01", this.client.getSubscriptionId(), "application/json, text/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VirtualMachineRunCommandInner>> getByVirtualMachineWithResponseAsync(String resourceGroupName, String vmName, String runCommandName, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (runCommandName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter runCommandName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return this.service.getByVirtualMachine(this.client.getEndpoint(), resourceGroupName, vmName, runCommandName, expand, "2024-03-01", this.client.getSubscriptionId(), "application/json, text/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineRunCommandInner> getByVirtualMachineAsync(String resourceGroupName, String vmName, String runCommandName) {
        String expand = null;
        return this.getByVirtualMachineWithResponseAsync(resourceGroupName, vmName, runCommandName, expand).flatMap(res -> Mono.justOrEmpty((Object)((Object)((VirtualMachineRunCommandInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VirtualMachineRunCommandInner> getByVirtualMachineWithResponse(String resourceGroupName, String vmName, String runCommandName, String expand, Context context) {
        return (Response)this.getByVirtualMachineWithResponseAsync(resourceGroupName, vmName, runCommandName, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineRunCommandInner getByVirtualMachine(String resourceGroupName, String vmName, String runCommandName) {
        String expand = null;
        return (VirtualMachineRunCommandInner)((Object)this.getByVirtualMachineWithResponse(resourceGroupName, vmName, runCommandName, expand, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineRunCommandInner>> listByVirtualMachineSinglePageAsync(String resourceGroupName, String vmName, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualMachine(this.client.getEndpoint(), resourceGroupName, vmName, expand, "2024-03-01", this.client.getSubscriptionId(), "application/json, text/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineRunCommandsListResult)res.getValue()).value(), ((VirtualMachineRunCommandsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineRunCommandInner>> listByVirtualMachineSinglePageAsync(String resourceGroupName, String vmName, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2024-03-01";
        String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return this.service.listByVirtualMachine(this.client.getEndpoint(), resourceGroupName, vmName, expand, "2024-03-01", this.client.getSubscriptionId(), "application/json, text/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineRunCommandsListResult)res.getValue()).value(), ((VirtualMachineRunCommandsListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualMachineRunCommandInner> listByVirtualMachineAsync(String resourceGroupName, String vmName, String expand) {
        return new PagedFlux(() -> this.listByVirtualMachineSinglePageAsync(resourceGroupName, vmName, expand), nextLink -> this.listByVirtualMachineNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualMachineRunCommandInner> listByVirtualMachineAsync(String resourceGroupName, String vmName) {
        String expand = null;
        return new PagedFlux(() -> this.listByVirtualMachineSinglePageAsync(resourceGroupName, vmName, expand), nextLink -> this.listByVirtualMachineNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VirtualMachineRunCommandInner> listByVirtualMachineAsync(String resourceGroupName, String vmName, String expand, Context context) {
        return new PagedFlux(() -> this.listByVirtualMachineSinglePageAsync(resourceGroupName, vmName, expand, context), nextLink -> this.listByVirtualMachineNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineRunCommandInner> listByVirtualMachine(String resourceGroupName, String vmName) {
        String expand = null;
        return new PagedIterable(this.listByVirtualMachineAsync(resourceGroupName, vmName, expand));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualMachineRunCommandInner> listByVirtualMachine(String resourceGroupName, String vmName, String expand, Context context) {
        return new PagedIterable(this.listByVirtualMachineAsync(resourceGroupName, vmName, expand, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RunCommandDocumentBaseInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json, text/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RunCommandListResult)res.getValue()).value(), ((RunCommandListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RunCommandDocumentBaseInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json, text/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RunCommandListResult)res.getValue()).value(), ((RunCommandListResult)res.getValue()).nextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineRunCommandInner>> listByVirtualMachineNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json, text/json";
        return FluxUtil.withContext(context -> this.service.listByVirtualMachineNext(nextLink, this.client.getEndpoint(), "application/json, text/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineRunCommandsListResult)res.getValue()).value(), ((VirtualMachineRunCommandsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualMachineRunCommandInner>> listByVirtualMachineNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json, text/json";
        context = this.client.mergeContext(context);
        return this.service.listByVirtualMachineNext(nextLink, this.client.getEndpoint(), "application/json, text/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualMachineRunCommandsListResult)res.getValue()).value(), ((VirtualMachineRunCommandsListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    public static interface VirtualMachineRunCommandsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/runCommands")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RunCommandListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="subscriptionId") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.Compute/locations/{location}/runCommands/{commandId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RunCommandDocumentInner>> get(@HostParam(value="$host") String var1, @PathParam(value="location") String var2, @PathParam(value="commandId") String var3, @QueryParam(value="api-version") String var4, @PathParam(value="subscriptionId") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @PathParam(value="runCommandName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") VirtualMachineRunCommandInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @PathParam(value="runCommandName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @BodyParam(value="application/json") VirtualMachineRunCommandUpdate var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @PathParam(value="runCommandName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands/{runCommandName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<VirtualMachineRunCommandInner>> getByVirtualMachine(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @PathParam(value="runCommandName") String var4, @QueryParam(value="$expand") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachines/{vmName}/runCommands")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<VirtualMachineRunCommandsListResult>> listByVirtualMachine(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmName") String var3, @QueryParam(value="$expand") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RunCommandListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<VirtualMachineRunCommandsListResult>> listByVirtualMachineNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

