/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.InstanceViewStatus;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroupType;
import com.azure.resourcemanager.compute.models.SubResourceWithColocationStatus;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class ProximityPlacementGroupInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ProximityPlacementGroupInner.class);
    @JsonProperty(value="properties.proximityPlacementGroupType")
    private ProximityPlacementGroupType proximityPlacementGroupType;
    @JsonProperty(value="properties.virtualMachines", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceWithColocationStatus> virtualMachines;
    @JsonProperty(value="properties.virtualMachineScaleSets", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceWithColocationStatus> virtualMachineScaleSets;
    @JsonProperty(value="properties.availabilitySets", access=JsonProperty.Access.WRITE_ONLY)
    private List<SubResourceWithColocationStatus> availabilitySets;
    @JsonProperty(value="properties.colocationStatus")
    private InstanceViewStatus colocationStatus;

    public ProximityPlacementGroupType proximityPlacementGroupType() {
        return this.proximityPlacementGroupType;
    }

    public ProximityPlacementGroupInner withProximityPlacementGroupType(ProximityPlacementGroupType proximityPlacementGroupType) {
        this.proximityPlacementGroupType = proximityPlacementGroupType;
        return this;
    }

    public List<SubResourceWithColocationStatus> virtualMachines() {
        return this.virtualMachines;
    }

    public List<SubResourceWithColocationStatus> virtualMachineScaleSets() {
        return this.virtualMachineScaleSets;
    }

    public List<SubResourceWithColocationStatus> availabilitySets() {
        return this.availabilitySets;
    }

    public InstanceViewStatus colocationStatus() {
        return this.colocationStatus;
    }

    public ProximityPlacementGroupInner withColocationStatus(InstanceViewStatus colocationStatus) {
        this.colocationStatus = colocationStatus;
        return this;
    }

    public ProximityPlacementGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ProximityPlacementGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.virtualMachines() != null) {
            this.virtualMachines().forEach(e -> e.validate());
        }
        if (this.virtualMachineScaleSets() != null) {
            this.virtualMachineScaleSets().forEach(e -> e.validate());
        }
        if (this.availabilitySets() != null) {
            this.availabilitySets().forEach(e -> e.validate());
        }
        if (this.colocationStatus() != null) {
            this.colocationStatus().validate();
        }
    }
}

