/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.models.SnapshotInner;
import com.azure.resourcemanager.compute.models.CreationSource;
import com.azure.resourcemanager.compute.models.Disk;
import com.azure.resourcemanager.compute.models.DiskCreateOption;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.SnapshotSkuType;
import com.azure.resourcemanager.compute.models.VirtualMachineCustomImage;
import com.azure.resourcemanager.compute.models.VirtualMachineImage;
import com.azure.resourcemanager.resources.fluentcore.arm.models.GroupableResource;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Refreshable;
import com.azure.resourcemanager.resources.fluentcore.model.Updatable;
import reactor.core.publisher.Mono;

public interface Snapshot
extends GroupableResource<ComputeManager, SnapshotInner>,
Refreshable<Snapshot>,
Updatable<Update> {
    public SnapshotSkuType skuType();

    public boolean incremental();

    public DiskCreateOption creationMethod();

    public int sizeInGB();

    public OperatingSystemTypes osType();

    public CreationSource source();

    public String grantAccess(int var1);

    public Mono<String> grantAccessAsync(int var1);

    public void revokeAccess();

    public Mono<Void> revokeAccessAsync();

    public static interface Update
    extends Appliable<Snapshot>,
    Resource.UpdateWithTags<Update>,
    UpdateStages.WithSku,
    UpdateStages.WithOSSettings {
    }

    public static interface UpdateStages {

        public static interface WithOSSettings {
            public Update withOSType(OperatingSystemTypes var1);
        }

        public static interface WithSku {
            public Update withSku(SnapshotSkuType var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<Snapshot>,
        Resource.DefinitionWithTags<WithCreate>,
        WithSize,
        WithSku,
        WithIncremental {
        }

        public static interface WithSku {
            public WithCreate withSku(SnapshotSkuType var1);
        }

        public static interface WithIncremental {
            public WithCreate withIncremental(boolean var1);
        }

        public static interface WithSize {
            public WithCreate withSizeInGB(int var1);
        }

        public static interface WithDataSnapshotFromImage {
            public WithCreate fromImage(String var1, int var2);

            public WithCreate fromImage(VirtualMachineImage var1, int var2);

            public WithCreate fromImage(VirtualMachineCustomImage var1, int var2);
        }

        public static interface WithOSSnapshotFromImage {
            public WithCreate fromImage(String var1, OperatingSystemTypes var2);

            public WithCreate fromImage(VirtualMachineImage var1);

            public WithCreate fromImage(VirtualMachineCustomImage var1);
        }

        public static interface WithDataSnapshotFromSnapshot {
            public WithCreate withDataFromSnapshot(String var1);

            public WithCreate withDataFromSnapshot(Snapshot var1);
        }

        public static interface WithDataSnapshotFromDisk {
            public WithCreate withDataFromDisk(String var1);

            public WithCreate withDataFromDisk(Disk var1);
        }

        public static interface WithDataSnapshotFromVhd {
            public WithCreate withDataFromVhd(String var1);

            public WithCreate withDataFromVhd(String var1, String var2);
        }

        public static interface WithDataSnapshotSource
        extends WithDataSnapshotFromVhd,
        WithDataSnapshotFromDisk,
        WithDataSnapshotFromSnapshot {
        }

        public static interface WithLinuxSnapshotSource {
            public WithCreate withLinuxFromDisk(String var1);

            public WithCreate withLinuxFromDisk(Disk var1);

            public WithCreate withLinuxFromSnapshot(String var1);

            public WithCreate withLinuxFromSnapshot(Snapshot var1);

            public WithCreate withLinuxFromVhd(String var1);

            public WithCreate withLinuxFromVhd(String var1, String var2);
        }

        public static interface WithWindowsSnapshotSource {
            public WithCreate withWindowsFromDisk(String var1);

            public WithCreate withWindowsFromDisk(Disk var1);

            public WithCreate withWindowsFromSnapshot(String var1);

            public WithCreate withWindowsFromSnapshot(Snapshot var1);

            public WithCreate withWindowsFromVhd(String var1);

            public WithCreate withWindowsFromVhd(String var1, String var2);
        }

        public static interface WithSnapshotSource
        extends WithWindowsSnapshotSource,
        WithLinuxSnapshotSource,
        WithDataSnapshotSource {
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithSnapshotSource> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithSnapshotSource,
    DefinitionStages.WithWindowsSnapshotSource,
    DefinitionStages.WithLinuxSnapshotSource,
    DefinitionStages.WithDataSnapshotSource,
    DefinitionStages.WithDataSnapshotFromVhd,
    DefinitionStages.WithDataSnapshotFromDisk,
    DefinitionStages.WithDataSnapshotFromSnapshot,
    DefinitionStages.WithCreate {
    }
}

