// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines an update domain for the cloud service.
 */
@Immutable
public final class UpdateDomainInner implements JsonSerializable<UpdateDomainInner> {
    /*
     * Resource Id
     */
    private String id;

    /*
     * Resource Name
     */
    private String name;

    /**
     * Creates an instance of UpdateDomainInner class.
     */
    public UpdateDomainInner() {
    }

    /**
     * Get the id property: Resource Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: Resource Name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UpdateDomainInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UpdateDomainInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the UpdateDomainInner.
     */
    public static UpdateDomainInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UpdateDomainInner deserializedUpdateDomainInner = new UpdateDomainInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedUpdateDomainInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedUpdateDomainInner.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUpdateDomainInner;
        });
    }
}
