// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The instance view of a capacity reservation that provides as snapshot of the runtime properties of the capacity
 * reservation that is managed by the platform and can change outside of control plane operations.
 */
@Fluent
public class CapacityReservationInstanceView implements JsonSerializable<CapacityReservationInstanceView> {
    /*
     * Unutilized capacity of the capacity reservation.
     */
    private CapacityReservationUtilization utilizationInfo;

    /*
     * The resource status information.
     */
    private List<InstanceViewStatus> statuses;

    /**
     * Creates an instance of CapacityReservationInstanceView class.
     */
    public CapacityReservationInstanceView() {
    }

    /**
     * Get the utilizationInfo property: Unutilized capacity of the capacity reservation.
     * 
     * @return the utilizationInfo value.
     */
    public CapacityReservationUtilization utilizationInfo() {
        return this.utilizationInfo;
    }

    /**
     * Set the utilizationInfo property: Unutilized capacity of the capacity reservation.
     * 
     * @param utilizationInfo the utilizationInfo value to set.
     * @return the CapacityReservationInstanceView object itself.
     */
    public CapacityReservationInstanceView withUtilizationInfo(CapacityReservationUtilization utilizationInfo) {
        this.utilizationInfo = utilizationInfo;
        return this;
    }

    /**
     * Get the statuses property: The resource status information.
     * 
     * @return the statuses value.
     */
    public List<InstanceViewStatus> statuses() {
        return this.statuses;
    }

    /**
     * Set the statuses property: The resource status information.
     * 
     * @param statuses the statuses value to set.
     * @return the CapacityReservationInstanceView object itself.
     */
    public CapacityReservationInstanceView withStatuses(List<InstanceViewStatus> statuses) {
        this.statuses = statuses;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (utilizationInfo() != null) {
            utilizationInfo().validate();
        }
        if (statuses() != null) {
            statuses().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("utilizationInfo", this.utilizationInfo);
        jsonWriter.writeArrayField("statuses", this.statuses, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CapacityReservationInstanceView from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CapacityReservationInstanceView if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CapacityReservationInstanceView.
     */
    public static CapacityReservationInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CapacityReservationInstanceView deserializedCapacityReservationInstanceView
                = new CapacityReservationInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("utilizationInfo".equals(fieldName)) {
                    deserializedCapacityReservationInstanceView.utilizationInfo
                        = CapacityReservationUtilization.fromJson(reader);
                } else if ("statuses".equals(fieldName)) {
                    List<InstanceViewStatus> statuses
                        = reader.readArray(reader1 -> InstanceViewStatus.fromJson(reader1));
                    deserializedCapacityReservationInstanceView.statuses = statuses;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCapacityReservationInstanceView;
        });
    }
}
